/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.hierarchy;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.dimension.OlapRoleDimensionDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.hierarchy.OlapRoleHierarchyDefinitionValidator;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="hierarchy")
public class OlapRoleHierarchyDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleDimensionDefinition, OlapRoleHierarchyDefinition>,
IOlapRoleNamedDefinition {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapRoleHierarchyDefinition.class, "name");
    public static final CdProperty AUTHORIZED_MEMBER_NAMES_TYPE = new CdReadWriteProperty(OlapRoleHierarchyDefinition.class, "authorizedMemberNamesType");
    public static final CdProperty AUTHORIZED_MEMBER_NAMES = new CdReadWriteProperty(OlapRoleHierarchyDefinition.class, "authorizedMemberNames");
    public static final CdProperty DEFAULT_MEMBER_NAME = new CdReadWriteProperty(OlapRoleHierarchyDefinition.class, "defaultMember");
    public static final CdProperty APPLY_TO_CELLS = new CdReadWriteProperty(OlapRoleHierarchyDefinition.class, "applyToCells");
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlElement(name="authorizedMemberNamesType", required=true)
    @Nullable
    private OlapRoleEntityListTypeDefinition authorizedMemberNamesType;
    @XmlElement(name="authorizedMemberNames", required=false)
    @Nullable
    private String authorizedMemberNames;
    @XmlElement(name="defaultMemberName", required=false)
    @Nullable
    private String defaultMember;
    @XmlElement(name="applyToCells", required=false)
    private boolean applyToCells;

    public OlapRoleHierarchyDefinition() {
    }

    public OlapRoleHierarchyDefinition(String name) {
        this.name = name;
        this.authorizedMemberNamesType = OlapRoleEntityListTypeDefinition.ALL;
    }

    public OlapRoleHierarchyDefinition(String name, OlapRoleEntityListTypeDefinition authorizedMemberNamesType) {
        this.name = name;
        this.authorizedMemberNamesType = authorizedMemberNamesType;
    }

    public OlapRoleHierarchyDefinition(String name, @Nullable OlapRoleEntityListTypeDefinition authorizedMemberNamesType, @Nullable String authorizedMemberNames, @Nullable String defaultMember, @Nullable Boolean applyToCells) {
        this.name = name;
        this.authorizedMemberNamesType = authorizedMemberNamesType;
        this.authorizedMemberNames = authorizedMemberNames;
        this.defaultMember = defaultMember;
        this.applyToCells = applyToCells != null ? applyToCells : false;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapRoleEntityListTypeDefinition getAuthorizedMemberNamesType() {
        return this.authorizedMemberNamesType;
    }

    public void setAuthorizedMemberNamesType(@Nullable OlapRoleEntityListTypeDefinition authorizedMemberNamesType) {
        this.authorizedMemberNamesType = authorizedMemberNamesType;
    }

    @Nullable
    public String getAuthorizedMemberNames() {
        if (StringUtils.isBlank((CharSequence)this.authorizedMemberNames)) {
            this.authorizedMemberNames = null;
        }
        return this.authorizedMemberNames;
    }

    public void setAuthorizedMemberNames(@Nullable String authorizedMemberNames) {
        if (StringUtils.isBlank((CharSequence)authorizedMemberNames)) {
            authorizedMemberNames = null;
        }
        this.authorizedMemberNames = authorizedMemberNames;
    }

    @Nullable
    public String getDefaultMember() {
        if (StringUtils.isBlank((CharSequence)this.defaultMember)) {
            return null;
        }
        return this.defaultMember;
    }

    public void setDefaultMemberName(@Nullable String defaultMemberName) {
        if (StringUtils.isBlank((CharSequence)defaultMemberName)) {
            this.defaultMember = null;
        }
        this.defaultMember = defaultMemberName;
    }

    public boolean isApplyToCells() {
        return this.applyToCells;
    }

    public void setApplyToCells(boolean applyToCells) {
        this.applyToCells = applyToCells;
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleDimensionDefinition, OlapRoleHierarchyDefinition> getValidator() {
        return new OlapRoleHierarchyDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleHierarchyDefinition that = (OlapRoleHierarchyDefinition)o;
        if (this.applyToCells != that.applyToCells) {
            return false;
        }
        if (this.authorizedMemberNames != null ? !this.authorizedMemberNames.equals(that.authorizedMemberNames) : that.authorizedMemberNames != null) {
            return false;
        }
        if (this.authorizedMemberNamesType != that.authorizedMemberNamesType) {
            return false;
        }
        if (this.defaultMember != null ? !this.defaultMember.equals(that.defaultMember) : that.defaultMember != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.authorizedMemberNamesType != null ? this.authorizedMemberNamesType.hashCode() : 0);
        result = 31 * result + (this.authorizedMemberNames != null ? this.authorizedMemberNames.hashCode() : 0);
        result = 31 * result + (this.defaultMember != null ? this.defaultMember.hashCode() : 0);
        result = 31 * result + (this.applyToCells ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.name == null ? "<null>" : this.name;
    }
}

