/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.cube;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.common.IOlapRoleConstraintDefaultValueDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleAccessDefinition;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupDefinition;
import crazydev.iccube.authorization.definition.measuregroup.OlapRoleMeasureGroupEntityListDefinition;
import crazydev.iccube.authorization.definition.schema.OlapRoleSchemaDefinition;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.authorization.validation.cube.OlapRoleCubeDefinitionValidator;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="cube")
public class OlapRoleCubeDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleSchemaDefinition, OlapRoleCubeDefinition>,
IOlapRoleConstraintDefaultValueDefinition,
IOlapRoleNamedDefinition {
    public static final CdProperty NAME = new CdReadWriteProperty(OlapRoleCubeDefinition.class, "name");
    public static final CdProperty ACCESS = new CdReadWriteProperty(OlapRoleCubeDefinition.class, "access");
    public static final CdProperty AUTHORIZED_MEASURE_GROUP_NAMES = new CdReadWriteProperty(OlapRoleCubeDefinition.class, "authorizedMeasureGroupNames");
    @XmlAttribute(name="name", required=true)
    @Nullable
    private String name;
    @XmlAttribute(name="access", required=true)
    @Nullable
    private OlapRoleAccessDefinition access;
    @XmlElement(name="authorizedMeasureGroupNames", required=true)
    @Nullable
    private OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNames;
    @XmlElement(name="measureGroup", required=false)
    @Nullable
    private List<OlapRoleMeasureGroupDefinition> measureGroupPermissions;

    public OlapRoleCubeDefinition() {
    }

    public OlapRoleCubeDefinition(String name) {
        this.name = name;
        this.authorizedMeasureGroupNames = new OlapRoleMeasureGroupEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleCubeDefinition(String name, OlapRoleAccessDefinition access) {
        this.name = name;
        this.access = access;
        this.authorizedMeasureGroupNames = new OlapRoleMeasureGroupEntityListDefinition(OlapRoleEntityListTypeDefinition.ALL, new String[0]);
    }

    public OlapRoleCubeDefinition(String name, OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNames) {
        this.name = name;
        this.authorizedMeasureGroupNames = authorizedMeasureGroupNames;
    }

    public OlapRoleCubeDefinition(String name, OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNames, OlapRoleMeasureGroupDefinition measureGroup) {
        this.name = name;
        this.authorizedMeasureGroupNames = authorizedMeasureGroupNames;
        this.measureGroupPermissions = new ArrayList<OlapRoleMeasureGroupDefinition>();
        this.measureGroupPermissions.add(measureGroup);
    }

    @Override
    public void setupConstrainedDefaultValues(@Nullable Object owner) {
        if (owner instanceof OlapRoleSchemaDefinition) {
            OlapRoleSchemaDefinition schema = (OlapRoleSchemaDefinition)owner;
            OlapRoleAccessDefinition ownerAccess = schema.getAccess();
            if (ownerAccess == null) {
                this.access = OlapRoleAccessDefinition.READ;
            } else {
                switch (ownerAccess) {
                    case READ: {
                        this.access = OlapRoleAccessDefinition.READ;
                        break;
                    }
                    case WRITE: {
                        this.access = OlapRoleAccessDefinition.WRITE;
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapRoleAccessDefinition getAccess() {
        return this.access;
    }

    @Nullable
    public OlapRoleMeasureGroupEntityListDefinition getAuthorizedMeasureGroupNames() {
        return this.authorizedMeasureGroupNames;
    }

    public OlapRoleMeasureGroupEntityListDefinition getValidatedAuthorizedMeasureGroupNames() {
        if (this.authorizedMeasureGroupNames == null) {
            throw new CdProgrammingException("internal error: missing authorized measure-group names");
        }
        return this.authorizedMeasureGroupNames;
    }

    public void setAuthorizedMeasureGroupNames(OlapRoleMeasureGroupEntityListDefinition authorizedMeasureGroupNames) {
        this.authorizedMeasureGroupNames = authorizedMeasureGroupNames;
    }

    @Nullable
    public List<OlapRoleMeasureGroupDefinition> getMeasureGroupPermissions() {
        return this.measureGroupPermissions;
    }

    @Nullable
    public OlapRoleMeasureGroupDefinition getMeasureGroupPermission(String measureGroupName) {
        if (this.measureGroupPermissions != null) {
            for (OlapRoleMeasureGroupDefinition measureGroupPermission : this.measureGroupPermissions) {
                String measureGroupPermissionName = measureGroupPermission.getName();
                if (measureGroupPermissionName == null || !OlapCaseInsensitiveName.equals(measureGroupPermissionName, measureGroupName)) continue;
                return measureGroupPermission;
            }
        }
        return null;
    }

    public void addMeasureGroupPermission(OlapRoleMeasureGroupDefinition definition) {
        if (this.measureGroupPermissions == null) {
            this.measureGroupPermissions = new ArrayList<OlapRoleMeasureGroupDefinition>();
        }
        this.measureGroupPermissions.add(definition);
    }

    public boolean removeMeasureGroupPermission(OlapRoleMeasureGroupDefinition definition) {
        return this.measureGroupPermissions != null && this.measureGroupPermissions.remove(definition);
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleSchemaDefinition, OlapRoleCubeDefinition> getValidator() {
        return new OlapRoleCubeDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleCubeDefinition that = (OlapRoleCubeDefinition)o;
        if (this.access != that.access) {
            return false;
        }
        if (this.authorizedMeasureGroupNames != null ? !this.authorizedMeasureGroupNames.equals(that.authorizedMeasureGroupNames) : that.authorizedMeasureGroupNames != null) {
            return false;
        }
        if (this.measureGroupPermissions != null ? !this.measureGroupPermissions.equals(that.measureGroupPermissions) : that.measureGroupPermissions != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.access != null ? this.access.hashCode() : 0);
        result = 31 * result + (this.authorizedMeasureGroupNames != null ? this.authorizedMeasureGroupNames.hashCode() : 0);
        result = 31 * result + (this.measureGroupPermissions != null ? this.measureGroupPermissions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.name == null ? "<null>" : this.name;
    }
}

