/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.common;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.authorization.definition.common.OlapRoleEntityListTypeDefinition;
import crazydev.iccube.olap.util.OlapCaseInsensitiveNames;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class OlapRoleEntityListDefinition {
    @XmlAttribute(name="type", required=true)
    @Nullable
    private OlapRoleEntityListTypeDefinition type;
    @XmlElement(name="name", required=false)
    @Nullable
    private List<String> names;

    public OlapRoleEntityListDefinition() {
    }

    public OlapRoleEntityListDefinition(OlapRoleEntityListTypeDefinition type, String ... names) {
        this.type = type;
        if (names != null) {
            ArrayList<String> myNames = new ArrayList<String>();
            for (String name : names) {
                if (name == null) continue;
                myNames.add(name);
            }
            this.names = myNames;
        }
    }

    @Nullable
    public OlapRoleEntityListTypeDefinition getType() {
        return this.type;
    }

    public void setType(OlapRoleEntityListTypeDefinition type) {
        this.type = type;
    }

    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public void setNames(String ... names) {
        ArrayList<String> myNames = new ArrayList<String>();
        if (names != null && names.length != 0) {
            for (String name : names) {
                myNames.add(name);
            }
        }
        this.names = myNames;
    }

    public void setNames(OlapCaseInsensitiveNames names) {
        ArrayList<String> myNames = new ArrayList<String>();
        for (String name : names) {
            myNames.add(name);
        }
        this.names = myNames;
    }

    public boolean isAuthorizedName(String name) {
        switch (this.type) {
            case ALL: {
                return true;
            }
            case SELECTION: {
                OlapCaseInsensitiveNames myNames = this.names == null || this.names.isEmpty() ? new OlapCaseInsensitiveNames() : new OlapCaseInsensitiveNames(this.names);
                return myNames.contains(name);
            }
            case ALL_MINUS_SELECTION: {
                OlapCaseInsensitiveNames myNames = this.names == null || this.names.isEmpty() ? new OlapCaseInsensitiveNames() : new OlapCaseInsensitiveNames(this.names);
                return !myNames.contains(name);
            }
        }
        throw new CdProgrammingException("unsupported type [" + String.valueOf((Object)this.type) + "]");
    }

    public OlapCaseInsensitiveNames resolveAuthorizedNames(OlapCaseInsensitiveNames allNames) {
        switch (this.type) {
            case ALL: {
                return new OlapCaseInsensitiveNames(allNames);
            }
            case SELECTION: {
                OlapCaseInsensitiveNames myNames;
                OlapCaseInsensitiveNames olapCaseInsensitiveNames = myNames = this.names == null || this.names.isEmpty() ? new OlapCaseInsensitiveNames() : new OlapCaseInsensitiveNames(this.names);
                if (myNames.isEmpty()) {
                    return new OlapCaseInsensitiveNames();
                }
                ArrayList<String> resolved = new ArrayList<String>();
                for (String allName : allNames) {
                    if (!myNames.contains(allName)) continue;
                    resolved.add(allName);
                }
                return new OlapCaseInsensitiveNames(resolved);
            }
            case ALL_MINUS_SELECTION: {
                OlapCaseInsensitiveNames myNames = this.names == null || this.names.isEmpty() ? new OlapCaseInsensitiveNames() : new OlapCaseInsensitiveNames(this.names);
                ArrayList<String> resolved = new ArrayList<String>();
                for (String allName : allNames) {
                    if (myNames.contains(allName)) continue;
                    resolved.add(allName);
                }
                return new OlapCaseInsensitiveNames(resolved);
            }
        }
        throw new CdProgrammingException("unsupported type [" + String.valueOf((Object)this.type) + "]");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleEntityListDefinition that = (OlapRoleEntityListDefinition)o;
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.names != null ? this.names.hashCode() : 0);
        return result;
    }
}

