/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authorization.definition.application;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.iccube.authorization.definition.application.OlapRoleAlertApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleApplicationFeatureDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleBuilderApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleGviApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleMdxIdeApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleMonitoringApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardApplicationApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardDataSourcesApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardDiscussionApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardLocalizationsApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardNoteApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardPageComponentsApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardSnapshotApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardThemesApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDashboardWidgetTemplatesApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportDocManagementApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleReportGadgetApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleUxApplicationDefinition;
import crazydev.iccube.authorization.definition.application.OlapRoleXmlaApplicationDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleConstraintDefaultValueDefinition;
import crazydev.iccube.authorization.definition.common.IOlapRoleNamedDefinition;
import crazydev.iccube.authorization.definition.role.OlapRoleDefinition;
import crazydev.iccube.authorization.validation.application.OlapRoleApplicationsDefinitionValidator;
import crazydev.iccube.authorization.validation.common.IOlapRoleDefinitionValidationEnabled;
import crazydev.iccube.authorization.validation.common.OlapRoleDefinitionValidationContext;
import crazydev.iccube.validation.OlapValidator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="applications")
public class OlapRoleApplicationsDefinition
implements IOlapRoleDefinitionValidationEnabled<OlapRoleDefinition, OlapRoleApplicationsDefinition>,
IOlapRoleConstraintDefaultValueDefinition,
IOlapRoleNamedDefinition {
    public static final CdProperty PERMISSIONS = new CdReadWriteProperty(OlapRoleApplicationsDefinition.class, "permissions"){

        public Object get(Object bean) throws IllegalArgumentException {
            OlapRoleApplicationsDefinition me = (OlapRoleApplicationsDefinition)bean;
            me.fixPermissionsForEdition();
            return me.permissions;
        }
    };
    @XmlElementRefs(value={@XmlElementRef(type=OlapRoleMonitoringApplicationDefinition.class), @XmlElementRef(type=OlapRoleAlertApplicationDefinition.class), @XmlElementRef(type=OlapRoleBuilderApplicationDefinition.class), @XmlElementRef(type=OlapRoleMdxIdeApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDocManagementApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardApplicationApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportGadgetApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardDataSourcesApplicationDefinition.class), @XmlElementRef(type=OlapRoleXmlaApplicationDefinition.class), @XmlElementRef(type=OlapRoleGviApplicationDefinition.class), @XmlElementRef(type=OlapRoleUxApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardDiscussionApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardNoteApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardSnapshotApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardThemesApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardWidgetTemplatesApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardLocalizationsApplicationDefinition.class), @XmlElementRef(type=OlapRoleReportDashboardPageComponentsApplicationDefinition.class)})
    @Nullable
    private List<OlapRoleApplicationDefinition> permissions;

    public OlapRoleApplicationsDefinition() {
    }

    public OlapRoleApplicationsDefinition(List<OlapRoleApplicationDefinition> permissions) {
        this.permissions = permissions;
    }

    public static OlapRoleApplicationDefinition fromName(String name, List<OlapRoleApplicationFeatureDefinition> features) {
        List<OlapRoleApplicationDefinition> apps = OlapRoleApplicationsDefinition.createAllApplications();
        for (OlapRoleApplicationDefinition app : apps) {
            if (!app.getName().equals(name)) continue;
            return app.create(features);
        }
        throw new RuntimeException("internal error: missing application for [" + name + "]");
    }

    private static List<OlapRoleApplicationDefinition> createAllApplications() {
        ArrayList<OlapRoleApplicationDefinition> applications = new ArrayList<OlapRoleApplicationDefinition>();
        applications.add(new OlapRoleXmlaApplicationDefinition());
        applications.add(new OlapRoleGviApplicationDefinition());
        applications.add(new OlapRoleUxApplicationDefinition());
        applications.add(new OlapRoleMdxIdeApplicationDefinition());
        applications.add(new OlapRoleBuilderApplicationDefinition());
        applications.add(new OlapRoleReportDocManagementApplicationDefinition());
        applications.add(new OlapRoleMonitoringApplicationDefinition());
        applications.add(new OlapRoleAlertApplicationDefinition());
        applications.add(new OlapRoleReportDashboardApplicationDefinition());
        applications.add(new OlapRoleReportDashboardApplicationApplicationDefinition());
        applications.add(new OlapRoleReportGadgetApplicationDefinition());
        applications.add(new OlapRoleReportDashboardDataSourcesApplicationDefinition());
        return applications;
    }

    public static List<OlapRoleApplicationDefinition> createAllPermissionsAsDisabled() {
        ArrayList<OlapRoleApplicationDefinition> myPermissions = new ArrayList<OlapRoleApplicationDefinition>();
        List<OlapRoleApplicationDefinition> applications = OlapRoleApplicationsDefinition.createAllApplications();
        for (OlapRoleApplicationDefinition application : applications) {
            myPermissions.add(application.createAsDisabled());
        }
        return myPermissions;
    }

    public static List<OlapRoleApplicationDefinition> createAllPermissionsAsEnabled() {
        ArrayList<OlapRoleApplicationDefinition> myPermissions = new ArrayList<OlapRoleApplicationDefinition>();
        List<OlapRoleApplicationDefinition> applications = OlapRoleApplicationsDefinition.createAllApplications();
        for (OlapRoleApplicationDefinition application : applications) {
            myPermissions.add(application.createAsEnabled());
        }
        return myPermissions;
    }

    @Override
    public void setupConstrainedDefaultValues(@Nullable Object owner) {
        OlapRoleDefinition role;
        if (owner instanceof OlapRoleDefinition && (role = (OlapRoleDefinition)owner).isFullControl()) {
            this.permissions = OlapRoleApplicationsDefinition.createAllPermissionsAsEnabled();
            return;
        }
        this.permissions = OlapRoleApplicationsDefinition.createAllPermissionsAsEnabled();
    }

    @Override
    public String getName() {
        return "Applications";
    }

    @Nullable
    private List<OlapRoleApplicationDefinition> getSortedPermissions() {
        List<OlapRoleApplicationDefinition> localPermissions = this.permissions;
        if (localPermissions == null) {
            return localPermissions;
        }
        ArrayList<OlapRoleApplicationDefinition> sortedPermissions = new ArrayList<OlapRoleApplicationDefinition>();
        for (OlapRoleApplicationDefinition localPermission : localPermissions) {
            sortedPermissions.add(localPermission);
        }
        Collections.sort(sortedPermissions, new Comparator<OlapRoleApplicationDefinition>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(OlapRoleApplicationDefinition o1, OlapRoleApplicationDefinition o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return name1.compareTo(name2);
            }
        });
        return sortedPermissions;
    }

    public void clearPermissions() {
        if (this.permissions != null) {
            this.permissions.clear();
        }
    }

    public List<OlapRoleApplicationDefinition> getPermissionsForUX() {
        this.fixPermissionsForEdition();
        return this.permissions;
    }

    @Nullable
    public List<OlapRoleApplicationDefinition> getPermissions() {
        return this.getSortedPermissions();
    }

    @Nullable
    public OlapRoleApplicationDefinition getPermissions(String appName) {
        List<OlapRoleApplicationDefinition> fixedPermissions = this.getSortedPermissions();
        if (fixedPermissions != null) {
            for (OlapRoleApplicationDefinition permission : fixedPermissions) {
                if (!appName.equals(permission.getName())) continue;
                return permission;
            }
        }
        return null;
    }

    public List<OlapRoleApplicationDefinition> getValidatedPermissions() {
        List<OlapRoleApplicationDefinition> fixedPermissions = this.getSortedPermissions();
        if (fixedPermissions == null) {
            throw new CdProgrammingException("internal error: missing applications permissions");
        }
        return fixedPermissions;
    }

    private void fixPermissionsForEdition() {
        if (this.permissions == null || this.permissions.isEmpty()) {
            this.permissions = OlapRoleApplicationsDefinition.createAllPermissionsAsDisabled();
        } else {
            List<OlapRoleApplicationDefinition> applications = OlapRoleApplicationsDefinition.createAllApplications();
            for (OlapRoleApplicationDefinition application : applications) {
                application.fixForEdition(this.permissions);
            }
            this.permissions = applications;
        }
    }

    @Override
    public OlapValidator<OlapRoleDefinitionValidationContext, OlapRoleDefinition, OlapRoleApplicationsDefinition> getValidator() {
        return new OlapRoleApplicationsDefinitionValidator();
    }

    @Override
    public String getContextVisualId() {
        return String.valueOf(this.getName());
    }

    public OlapRoleApplicationsDefinition copy() {
        ArrayList<OlapRoleApplicationDefinition> clone = new ArrayList<OlapRoleApplicationDefinition>();
        if (this.permissions != null) {
            for (OlapRoleApplicationDefinition permission : this.permissions) {
                clone.add(permission.copy());
            }
        }
        return new OlapRoleApplicationsDefinition(clone);
    }

    public void afterUnmarshal() {
        if (this.permissions != null) {
            this.permissions = this.permissions.stream().filter(p -> !p.isV7()).toList();
        }
        this.fixMissingUx();
        this.fixMissingAlert();
        this.fixMissingDashboard();
        this.fixMissingDashboardDataSources();
        this.fixMissingDashboardApplication();
        this.fixMissingDashboardGadgets();
    }

    private void fixMissingUx() {
        if (this.getPermissions("app.ux") == null) {
            this.addToPermissions(new OlapRoleUxApplicationDefinition().createAsEnabled());
        }
    }

    private void fixMissingAlert() {
        if (this.getPermissions("app.alert") == null) {
            this.addToPermissions(new OlapRoleAlertApplicationDefinition().createAsDisabled());
        }
    }

    private void fixMissingDashboard() {
        if (this.getPermissions("app.reportDashboard") == null) {
            this.addToPermissions(new OlapRoleReportDashboardApplicationDefinition().createAsDisabled());
        }
    }

    private void fixMissingDashboardApplication() {
        if (this.getPermissions("app.reportDashboardApplication") == null) {
            try {
                OlapRoleReportDashboardApplicationDefinition dashboard = (OlapRoleReportDashboardApplicationDefinition)this.getPermissions("app.reportDashboard");
                OlapRoleApplicationDefinition perms = dashboard != null ? new OlapRoleReportDashboardApplicationApplicationDefinition().createFromDashboard(dashboard) : new OlapRoleReportDashboardApplicationApplicationDefinition().createAsDisabled();
                this.addToPermissions(perms);
            }
            catch (RuntimeException ignored) {
                this.addToPermissions(new OlapRoleReportDashboardApplicationApplicationDefinition().createAsDisabled());
            }
        }
    }

    private void fixMissingDashboardGadgets() {
        if (this.getPermissions("app.reportGadget") == null) {
            try {
                OlapRoleReportDashboardApplicationDefinition dashboard = (OlapRoleReportDashboardApplicationDefinition)this.getPermissions("app.reportDashboard");
                OlapRoleApplicationDefinition perms = dashboard != null ? new OlapRoleReportGadgetApplicationDefinition().createFromDashboard(dashboard) : new OlapRoleReportGadgetApplicationDefinition().createAsDisabled();
                this.addToPermissions(perms);
            }
            catch (RuntimeException ignored) {
                this.addToPermissions(new OlapRoleReportGadgetApplicationDefinition().createAsDisabled());
            }
        }
    }

    private void fixMissingDashboardDataSources() {
        if (this.getPermissions("app.reportDashboardDataSources") == null) {
            try {
                OlapRoleReportDashboardApplicationDefinition dashboard = (OlapRoleReportDashboardApplicationDefinition)this.getPermissions("app.reportDashboard");
                OlapRoleApplicationDefinition perms = dashboard != null ? new OlapRoleReportDashboardDataSourcesApplicationDefinition().createFromDashboard(dashboard) : new OlapRoleReportDashboardDataSourcesApplicationDefinition().createAsDisabled();
                this.addToPermissions(perms);
            }
            catch (RuntimeException ignored) {
                this.addToPermissions(new OlapRoleReportDashboardDataSourcesApplicationDefinition().createAsDisabled());
            }
        }
    }

    private void addToPermissions(OlapRoleApplicationDefinition perms) {
        if (this.permissions != null) {
            this.permissions.add(perms);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OlapRoleApplicationsDefinition that = (OlapRoleApplicationsDefinition)o;
        List<OlapRoleApplicationDefinition> fixedPermissions = this.getSortedPermissions();
        List<OlapRoleApplicationDefinition> thatFixedPermissions = that.getSortedPermissions();
        return !(fixedPermissions != null ? !fixedPermissions.equals(thatFixedPermissions) : thatFixedPermissions != null);
    }

    public int hashCode() {
        List<OlapRoleApplicationDefinition> fixedPermissions = this.getSortedPermissions();
        return fixedPermissions != null ? fixedPermissions.hashCode() : 0;
    }
}

