/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.authentication.validation.user;

import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authentication.definition.OlapUserDefinitions;
import crazydev.iccube.authentication.errors.OlapUserDefinitionErrorCode;
import crazydev.iccube.authentication.validation.common.OlapUserAbstractDefinitionValidator;
import crazydev.iccube.authentication.validation.common.OlapUserDefinitionValidationContext;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapUserDefinitionValidator
extends OlapUserAbstractDefinitionValidator<OlapUserDefinitions, OlapUserDefinition> {
    @Override
    protected void doValidate(OlapUserDefinitionValidationContext context, @Nullable OlapUserDefinitions owner, OlapUserDefinition me) {
        this.validateNotBlankField(context, OlapUserDefinition.NAME, me.getName());
        if (!me.hasPassword()) {
            context.addError(OlapUserDefinition.PASSWORD, OlapUserDefinitionErrorCode.FIELD_IS_EMPTY, new Serializable[]{OlapUserDefinition.PASSWORD.getName()});
        }
        this.validateNotNullField(context, OlapUserDefinition.ROLES, me.getRoles());
        List<String> roleNames = me.getRoles();
        if (roleNames.isEmpty()) {
            context.addError(OlapUserDefinitionErrorCode.ROLES_UNDEFINED, new Serializable[]{me.getName()});
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String roleName : roleNames) {
            if (roleName == null || roleName.trim().isEmpty()) {
                context.addError(OlapUserDefinitionErrorCode.ROLE_UNDEFINED, new Serializable[]{me.getName()});
            }
            if (uniqueNames.contains(roleName)) {
                context.addError(OlapUserDefinitionErrorCode.ROLE_DUPLICATED_NAME, new Serializable[]{me.getName(), roleName});
                continue;
            }
            if (!this.isRoleDefined(context, roleName)) {
                context.addError(OlapUserDefinitionErrorCode.ROLE_UNKNOWN, new Serializable[]{me.getName(), roleName});
                continue;
            }
            uniqueNames.add(roleName);
        }
    }

    private boolean isRoleDefined(OlapUserDefinitionValidationContext context, String roleName) {
        IOlapPermissionsService service = context.getRolePermissionsService();
        return service.hasRole(roleName);
    }
}

