/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.mapreduce;

import com.mongodb.Cursor;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.mapreduce.OlapBuilderMongoDbMapReduceDataTable;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbMapReduceHelper {
    public static Cursor mapReduce(OlapBuilderContext context, OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbMapReduceDataTable table) {
        return OlapBuilderMongoDbMapReduceHelper.mapReduce(context, connection, table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static DBObject mapReduceOne(OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbMapReduceDataTable table) {
        try (Cursor cursor = OlapBuilderMongoDbMapReduceHelper.mapReduce(null, connection, table, 1);){
            if (cursor.hasNext()) {
                DBObject one;
                DBObject dBObject = one = (DBObject)cursor.next();
                return dBObject;
            }
            DBObject dBObject = null;
            return dBObject;
        }
    }

    public static Cursor mapReduce(@Nullable OlapBuilderContext context, OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbMapReduceDataTable table, @Nullable Integer forceBatchSize) {
        return null;
    }

    private static Cursor asCursor(MongoClient mongo, OlapBuilderMongoDbMapReduceDataTable table, @Nullable Integer forceBatchSize, @Nullable MapReduceOutput lastOutput) {
        if (lastOutput == null) {
            return new EmptyCursor(mongo.getAddress());
        }
        Iterable res_ = lastOutput.results();
        if (res_ == null) {
            return new EmptyCursor(mongo.getAddress());
        }
        if (res_ instanceof DBCursor) {
            Integer batchSize;
            Integer limit;
            DBCursor cursor = (DBCursor)res_;
            Integer skip = table.getSkip();
            if (skip != null) {
                cursor.skip(skip.intValue());
            }
            if ((limit = table.getLimit()) != null) {
                cursor.limit(limit.intValue());
            }
            Integer n = batchSize = forceBatchSize != null ? forceBatchSize : table.getBatchSize();
            if (batchSize != null) {
                cursor.batchSize(batchSize.intValue());
            }
            return cursor;
        }
        return new InlineCursor(mongo.getAddress(), res_);
    }

    static class EmptyCursor
    implements Cursor {
        private final ServerAddress serverAddress;

        public EmptyCursor(ServerAddress serverAddress) {
            this.serverAddress = serverAddress;
        }

        public long getCursorId() {
            return 0L;
        }

        public ServerAddress getServerAddress() {
            return this.serverAddress;
        }

        public boolean hasNext() {
            return false;
        }

        public DBObject next() {
            return null;
        }

        public void remove() {
        }

        public void close() {
        }
    }

    static class InlineCursor
    implements Cursor {
        private final ServerAddress serverAddress;
        private final Iterator<DBObject> items;

        public InlineCursor(ServerAddress serverAddress, Iterable<DBObject> items) {
            this.serverAddress = serverAddress;
            this.items = items.iterator();
        }

        public long getCursorId() {
            return 0L;
        }

        public ServerAddress getServerAddress() {
            return this.serverAddress;
        }

        public boolean hasNext() {
            return this.items.hasNext();
        }

        public DBObject next() {
            return this.items.next();
        }

        public void remove() {
            this.items.remove();
        }

        public void close() {
        }
    }
}

