/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.mapreduce;

import com.mongodb.DBObject;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import crazydev.iccube.builder.mongodb.datatable.mapreduce.OlapBuilderMongoDbMapReduceDataTableValidator;
import crazydev.iccube.builder.mongodb.datatable.mapreduce.OlapBuilderMongoDbMapReduceHelper;
import crazydev.iccube.builder.mongodb.datatable.mapreduce.OlapBuilderMongoDbMapReduceTableRowReader;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="mongoDB-map-reduce")
public class OlapBuilderMongoDbMapReduceDataTable
extends OlapBuilderMongoDbDataTable {
    public static final CdProperty MAP_REDUCE = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "mapReduceCommands", true){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty MAP_REDUCE_INCR_LOAD = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "mapReduceCommandsIncrLoad", true){

        public boolean isForIncrLoad() {
            return true;
        }

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty SKIP = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "skip", false);
    public static final CdProperty LIMIT = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "limit", false);
    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty(OlapBuilderMongoDbMapReduceDataTable.class, "batchSize", false);
    @XmlElement(name="mapReduceCommands", required=true)
    private String mapReduceCommands;
    @XmlElement(name="mapReduceCommandsIncrLoad", required=false)
    private String mapReduceCommandsIncrLoad;
    @XmlAttribute(name="skip", required=false)
    @Nullable
    protected Integer skip;
    @XmlAttribute(name="limit", required=false)
    @Nullable
    protected Integer limit;
    @XmlAttribute(name="batchSize", required=false)
    @Nullable
    protected Integer batchSize;

    @Override
    public boolean isNameReadOnly() {
        return false;
    }

    public String getMapReduceCommands() {
        return this.mapReduceCommands;
    }

    public List<DBObject> getMapReduceCommandsAsDBObject() {
        return OlapBuilderMongoDbHelper.asDBObjectList("table:" + this.getName() + ".mapReduce", this.mapReduceCommands);
    }

    public List<DBObject> getMapReduceCommandsIncrLoadAsDBObject(Comparable incrLoadMarker) {
        String json = this.addMarkers(this.mapReduceCommandsIncrLoad, incrLoadMarker, null);
        return OlapBuilderMongoDbHelper.asDBObjectList("table:" + this.getName() + ".mapReduceIncrLoad", json);
    }

    public String getInternalFriendlyTypeName() {
        return "MongoDB Map/Reduce Table";
    }

    @Nullable
    public Integer getSkip() {
        return this.skip;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator() {
        return new OlapBuilderMongoDbMapReduceDataTableValidator();
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderMongoDbMapReduceTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + this.getName() + ".mapReduce()");
    }

    @Override
    protected Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection) {
        return OlapBuilderMongoDbMapReduceHelper.mapReduceOne(connection, this);
    }

    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbMapReduceDataTable tableUpdate = (OlapBuilderMongoDbMapReduceDataTable)newTable;
        return !Objects.equals(this.mapReduceCommands, tableUpdate.mapReduceCommands);
    }
}

