/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.find;

import com.mongodb.BasicDBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithPrototypeDataTable;
import crazydev.iccube.builder.mongodb.datatable.find.OlapBuilderMongoDbFindDataTableValidator;
import crazydev.iccube.builder.mongodb.datatable.find.OlapBuilderMongoDbFindTableRowReader;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="mongoDB-find")
public class OlapBuilderMongoDbFindDataTable
extends OlapBuilderMongoDbWithPrototypeDataTable {
    public static final CdProperty QUERY = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "query", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty QUERY_INCRL_PART = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "queryIncrLoadPart", false){

        public boolean isForIncrLoad() {
            return true;
        }

        public boolean isForPartitioning() {
            return true;
        }

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty PROJECTION = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "projection", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty LIMIT = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbFindDataTable.class, "limit", false);
    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbFindDataTable.class, "batchSize", false);
    public static final CdProperty OPTIONS = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbFindDataTable.class, "options", false);
    public static final CdProperty PARTITION_FIELD = new CdReadWriteProperty(OlapBuilderMongoDbFindDataTable.class, "partitionField", false){

        public boolean isForPartitioning() {
            return true;
        }
    };
    @XmlAttribute(name="limit", required=false)
    @Nullable
    protected Integer limit;
    @XmlAttribute(name="batchSize", required=false)
    @Nullable
    protected Integer batchSize;
    @XmlAttribute(name="query", required=false)
    @Nullable
    private String query;
    @XmlAttribute(name="queryIncrLoadPart", required=false)
    @Nullable
    private String queryIncrLoadPart;
    @XmlAttribute(name="projection", required=false)
    private String projection;
    @XmlAttribute(name="options", required=false)
    private String options;
    @XmlAttribute(name="partitionField", required=false)
    private String partitionField;

    @Nullable
    public String getPartitioningColumnName() {
        return this.partitionField;
    }

    @Nullable
    public String getPartitioningColumnNameX() {
        return this.partitionField;
    }

    public String getInternalFriendlyTypeName() {
        return "MongoDB Find Table";
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator() {
        return new OlapBuilderMongoDbFindDataTableValidator();
    }

    @Override
    protected Object findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection) {
        return OlapBuilderMongoDbFindTableRowReader.first(connection, this);
    }

    public String getProjection() {
        return this.projection;
    }

    @Override
    public String getOptions() {
        return this.options;
    }

    public void onNewRow(OlapBuilderContext context, @Nullable IOlapBuilderTablePartitionKey partitionKey, int rowNb, IOlapBuilderTableRow data) {
        super.onNewRow(context, partitionKey, rowNb, data);
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderMongoDbFindTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + this.getName() + ".find()", null);
    }

    public boolean hasTablePartitioning() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.partitionField);
    }

    @Nullable
    public String getQueryIncrementalLoadPart(@Nullable Comparable incrLoadMarker, @Nullable Object partitionValue) {
        return this.addMarkers(this.queryIncrLoadPart, incrLoadMarker, partitionValue);
    }

    public boolean hasQueryIncrLoadPart() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.queryIncrLoadPart);
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreatePartitionTableRowReaders(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, IOlapBuilderTablePartitionKey partitionKey) {
        return new OlapBuilderMongoDbFindTableRowReader(context, connectionPool, -1, this, "MongoDB " + this.getName() + ".find()", partitionKey);
    }

    @Override
    protected DistinctIterable<BsonValue> getDistinct(MongoCollection<Document> collection) {
        BasicDBObject bsonQuery = OlapBuilderMongoDbTableRowReader.toBson("query", this.query);
        return collection.distinct(this.getPartitioningColumnName(), (Bson)bsonQuery, BsonValue.class);
    }

    public String getPartitionField() {
        return this.partitionField;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbFindDataTable tableUpdate = (OlapBuilderMongoDbFindDataTable)newTable;
        return !Objects.equals(this.query, tableUpdate.query) || !Objects.equals(this.projection, tableUpdate.projection);
    }
}

