/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.distinct;

import com.mongodb.BasicDBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import crazydev.iccube.builder.mongodb.datatable.distinct.OlapBuilderMongoDbDistinctDataTable;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;

class OlapBuilderMongoDbDistinctTableRowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderMongoDbDistinctDataTable, OlapBuilderMongoDbConnection> {
    private MongoCursor<BsonValue> iterator;

    OlapBuilderMongoDbDistinctTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderMongoDbDistinctDataTable table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)table, fullNameForEndUser);
    }

    static BsonValue firstNotNull(OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbDistinctDataTable table) {
        MongoDatabase bd = connection.getMongoDataBase();
        MongoCollection collection = bd.getCollection(table.getCollection());
        DistinctIterable<BsonValue> distinctQuery = OlapBuilderMongoDbDistinctTableRowReader.buildQuery(table, (MongoCollection<Document>)collection);
        MongoCursor iter = distinctQuery.iterator();
        while (iter.hasNext()) {
            BsonValue val = (BsonValue)iter.next();
            if (val == null) continue;
            iter.close();
            return val;
        }
        return null;
    }

    private static DistinctIterable<BsonValue> buildQuery(OlapBuilderMongoDbDistinctDataTable table, MongoCollection<Document> collection) {
        DistinctIterable query = collection.distinct(table.getFieldName(), (Bson)OlapBuilderMongoDbDistinctTableRowReader.toBson("query", table.getQuery()), BsonValue.class);
        if (table.getBatchSize() != null) {
            query = query.batchSize(table.getBatchSize().intValue());
        }
        return query;
    }

    private static BasicDBObject toBson(String fieldName, String bson) {
        return OlapBuilderMongoDbTableRowReader.toBson(fieldName, bson);
    }

    public boolean isRowSafe() {
        return true;
    }

    public void doInit() {
        this.initConnection();
        MongoDatabase bd = ((OlapBuilderMongoDbConnection)this.connection).getMongoDataBase();
        MongoCollection collection = bd.getCollection(((OlapBuilderMongoDbDistinctDataTable)this.table).getCollection());
        DistinctIterable<BsonValue> distinctQuery = OlapBuilderMongoDbDistinctTableRowReader.buildQuery((OlapBuilderMongoDbDistinctDataTable)this.table, (MongoCollection<Document>)collection);
        this.iterator = distinctQuery.iterator();
    }

    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        final BsonValue bsonValue = (BsonValue)this.iterator.next();
        return new IOlapBuilderTableRow(){
            final BsonValue value;
            {
                Objects.requireNonNull(this$0);
                this.value = bsonValue;
            }

            @Nullable
            public Comparable getJavaNativeDataValue(IOlapBuilderDataColumnDef columnDef) {
                return OlapBuilderMongoDbHelper.toValue(columnDef.getType(), this.value);
            }
        };
    }
}

