/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.distinct;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdJson;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbWithCollectionDataTable;
import crazydev.iccube.builder.mongodb.datatable.distinct.OlapBuilderMongoDbDistinctDataTableValidator;
import crazydev.iccube.builder.mongodb.datatable.distinct.OlapBuilderMongoDbDistinctTableRowReader;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bson.BsonValue;
import org.bson.Document;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="mongoDB-distinct")
public class OlapBuilderMongoDbDistinctDataTable
extends OlapBuilderMongoDbWithCollectionDataTable {
    public static final CdProperty FIELD_NAME = new CdReadWriteProperty(OlapBuilderMongoDbDistinctDataTable.class, "fieldName", true);
    public static final CdProperty QUERY = new CdReadWriteProperty(OlapBuilderMongoDbDistinctDataTable.class, "query", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdJson.class;
        }
    };
    public static final CdProperty BATCH_SIZE = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbDistinctDataTable.class, "batchSize", false);
    @XmlAttribute(name="batchSize", required=false)
    @Nullable
    protected Integer batchSize;
    @XmlAttribute(name="fieldName", required=false)
    @Nullable
    private String fieldName;
    @XmlAttribute(name="query", required=false)
    @Nullable
    private String query;

    public String getInternalFriendlyTypeName() {
        return "MongoDB Find Table";
    }

    public OlapBuilderValidator<IOlapBuilderDataSource<OlapBuilderMongoDbConnection>, IOlapBuilderDataTableDef<OlapBuilderMongoDbConnection>> getValidator() {
        return new OlapBuilderMongoDbDistinctDataTableValidator();
    }

    protected IOlapBuilderTableRowReader<OlapBuilderMongoDbConnection> doCreateFullTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount) {
        return new OlapBuilderMongoDbDistinctTableRowReader(context, connectionPool, maxRowCount, this, "MongoDB " + this.getName() + ".find()");
    }

    protected List<? extends IOlapBuilderDataColumnDef> doDiscoverAllColumns(OlapRuntimeContext context, OlapBuilderMongoDbConnection connection, OlapBuilderErrorManager errorManager) {
        ArrayList<OlapBuilderDataColumn> list = new ArrayList<OlapBuilderDataColumn>();
        BsonValue value = OlapBuilderMongoDbDistinctTableRowReader.firstNotNull(connection, this);
        OlapBuilderInputType type = OlapBuilderMongoDbHelper.toType(value);
        if (type == null) {
            return list;
        }
        OlapBuilderDataColumn column = new OlapBuilderDataColumn(type, value.getBsonType().name(), this.fieldName);
        list.add(column);
        return list;
    }

    protected Document findOneForDiscoverColumns(OlapBuilderMongoDbConnection connection) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbDistinctDataTable tableUpdate = (OlapBuilderMongoDbDistinctDataTable)newTable;
        return !Objects.equals(this.query, tableUpdate.query);
    }
}

