/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.utils.CdEnumerableForUi;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbWithCollectionDataTable
extends OlapBuilderMongoDbDataTable {
    public static final CdProperty COLLECTION = new CdReadWriteProperty(OlapBuilderMongoDbWithCollectionDataTable.class, "collection", true){

        public Class<?> getTypeForDefaultEditor() {
            return CdEnumerableForUi.class;
        }

        public List<String> getPossibleValues(@Nullable Object modelOwner, @Nullable Object model) {
            if (model == null) {
                return Collections.emptyList();
            }
            OlapBuilderMongoDbWithCollectionDataTable table = (OlapBuilderMongoDbWithCollectionDataTable)((Object)model);
            OlapBuilderMongoDbDataSource dataSource = (OlapBuilderMongoDbDataSource)table.getDataSource();
            if (dataSource == null) {
                return Collections.emptyList();
            }
            return dataSource.getCollectionNamesForUi();
        }

        public Object get(Object bean) throws IllegalArgumentException {
            OlapBuilderMongoDbWithCollectionDataTable table = (OlapBuilderMongoDbWithCollectionDataTable)((Object)bean);
            return table.getCollectionAsEnumerableForUi(table.collection);
        }
    };
    @XmlElement(name="collection", required=true)
    protected String collection;

    public OlapBuilderMongoDbWithCollectionDataTable() {
    }

    public OlapBuilderMongoDbWithCollectionDataTable(String tableName, String collection) {
        super(tableName);
        this.collection = collection;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    public boolean isRefreshColumnOnUpdate(IOlapBuilderDataTableDef newTable) {
        if (super.isRefreshColumnOnUpdate(newTable)) {
            return true;
        }
        OlapBuilderMongoDbWithCollectionDataTable tableUpdate = (OlapBuilderMongoDbWithCollectionDataTable)newTable;
        return !Objects.equals(this.collection, tableUpdate.collection);
    }
}

