/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.iccube.bson.ic3BsonCodecRegistry;
import com.iccube.bson.ic3BsonRow;
import com.iccube.bson.ic3BsonRowBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbLoggers;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import crazydev.iccube.builder.mongodb.error.OlapBuilderMongoDbErrorCode;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BSONException;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;
import org.bson.types.BasicBSONList;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBuilderMongoDbTableRowReader<TABLE extends OlapBuilderMongoDbDataTable>
extends OlapBuilderAbstractTableRowReader<TABLE, OlapBuilderMongoDbConnection> {
    protected MongoCursor<ic3BsonRow> result;
    protected OlapBuilderAbstractTablePartitionKey partitionKey;

    protected OlapBuilderMongoDbTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, TABLE table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    public boolean isRowSafe() {
        return true;
    }

    public void init() {
        try {
            super.init();
        }
        catch (MongoException ex) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (!this.result.hasNext()) {
            return null;
        }
        ic3BsonRow next = (ic3BsonRow)this.result.next();
        return next;
    }

    public void done() {
        if (this.result != null) {
            try {
                this.result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.done();
    }

    @Nullable
    public IOlapBuilderTablePartitionKey getPartitionKey() {
        return this.partitionKey;
    }

    public MongoCollection<Document> getCollection(String collectionName) {
        OlapProcessingFactsMode mode = this.context.getEngineContext().getOlapEngineProperties().getLoadProcessingFactsMode();
        MongoDatabase db = ((OlapBuilderMongoDbConnection)this.connection).getMongoClient().getDatabase(((OlapBuilderMongoDbDataSource)((OlapBuilderMongoDbConnection)this.connection).getDataSource()).getDbName());
        ic3BsonRowBuilder rowBuilder = this.buildRows(((OlapBuilderMongoDbDataTable)this.table).getAllColumns());
        db = db.withCodecRegistry((CodecRegistry)new ic3BsonCodecRegistry(db.getCodecRegistry(), rowBuilder, ((OlapBuilderMongoDbDataTable)this.table).getCacheStringValue(), mode));
        return db.getCollection(collectionName);
    }

    private ic3BsonRowBuilder buildRows(List<IOlapBuilderDataColumnDef> colNames) {
        ic3BsonRowBuilder rootNode = new ic3BsonRowBuilder(new Comparable[colNames.size()]);
        colNames.forEach(col -> {
            String colName = col.getName();
            String[] names = colName.split("\\.");
            ic3BsonRowBuilder node = rootNode;
            for (String name : names) {
                node = (ic3BsonRowBuilder)node.getOrCreateChild(name);
            }
            node.setIndex((IOlapBuilderDataColumnDef)col);
        });
        return rootNode;
    }

    public static BasicDBObject toBson(String fieldName, @Nullable String json) {
        try {
            return CdStringUtils.isNullOrBlank((String)json) ? new BasicDBObject() : BasicDBObject.parse((String)json);
        }
        catch (BSONException | JsonParseException ex) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{"[field:" + fieldName + "] " + ex.getMessage(), json});
        }
    }

    public static List<Bson> toBsonList(String fieldName, String kind, @Nullable String value) {
        return OlapBuilderMongoDbTableRowReader.toBsonList(fieldName, kind, value, false);
    }

    public static List<Bson> toBsonList(String fieldName, String kind, @Nullable String value, boolean forValidation) {
        String json;
        String string = json = CdStringUtils.isNotNullAndNotBlank((String)value) ? value : null;
        if (json == null) {
            return Collections.emptyList();
        }
        if (!((String)(value = ((String)value).trim())).startsWith("[")) {
            value = "[" + (String)value;
        }
        if (!((String)value).endsWith("]")) {
            value = (String)value + "]";
        }
        try {
            BasicDBObject bson = BasicDBObject.parse((String)("{ a: " + (String)value + "}"));
            Object list = bson.get("a");
            if (list instanceof BasicBSONList) {
                ArrayList<Bson> retList = new ArrayList<Bson>();
                BasicBSONList bList = (BasicBSONList)list;
                for (int i = 0; i < bList.size(); ++i) {
                    Object object = bList.get(i);
                    if (!(object instanceof Bson)) {
                        if (forValidation) {
                            throw new RuntimeException("[field:" + fieldName + "] incorrect type, BSON expected " + object.getClass().getSimpleName());
                        }
                        throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.UNEXPECTED_ERROR, new Serializable[]{"[field:" + fieldName + "] incorrect type, BSON expected " + object.getClass().getSimpleName()});
                    }
                    Bson miniBson = (Bson)object;
                    retList.add(miniBson);
                }
                return retList;
            }
            if (forValidation) {
                throw new RuntimeException("Internal Error");
            }
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.UNEXPECTED_ERROR, new Serializable[]{"should not be here"});
        }
        catch (RuntimeException ex) {
            if (forValidation) {
                throw ex;
            }
            OlapBuilderMongoDbLoggers.GENERAL.error((Object)("[MongoDB] [field:" + fieldName + "] unexpected JSON (" + kind + ") error"), (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.JSON_ERROR, new Serializable[]{kind, "[field:" + fieldName + "] " + ex.getMessage()});
        }
    }

    @Nullable
    protected Bson getColumnBasedFilter(Comparable incrLoadMarker) {
        Bson incrFilter = null;
        if (incrLoadMarker != null) {
            incrFilter = Filters.gt((String)((OlapBuilderMongoDbDataTable)this.table).getIncrementalLoadColumnName(), (Object)incrLoadMarker.toString());
        }
        Bson partFilter = null;
        if (this.partitionKey != null) {
            partFilter = Filters.eq((String)((OlapBuilderMongoDbDataTable)this.table).getPartitioningColumnName(), (Object)this.partitionKey.asPartitionKeyObject());
        }
        Bson filter = partFilter != null && incrFilter != null ? Filters.and((Bson[])new Bson[]{partFilter, incrFilter}) : (incrFilter != null ? incrFilter : partFilter);
        return filter;
    }

    public Object partitionKeyForReplacement() {
        return this.partitionKey.asPartitionKeyObject();
    }
}

