/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.common;

import com.mongodb.BasicDBObject;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import java.io.Serializable;
import org.bson.json.JsonParseException;

public abstract class OlapBuilderMongoDbDataTableValidator
extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderMongoDbConnection, IOlapBuilderDataSource<OlapBuilderMongoDbConnection>> {
    protected OlapBuilderMongoDbDataTableValidator() {
    }

    OlapBuilderMongoDbDataTableValidator(boolean validateDataTableAndColumnsWithDataSourceContent) {
        super(validateDataTableAndColumnsWithDataSourceContent);
    }

    public static void validateIsJson(OlapBuilderValidationContext context, CdProperty prop, String value) {
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return;
        }
        try {
            BasicDBObject.parse((String)value);
        }
        catch (JsonParseException exception) {
            context.addError(prop, (CdErrorCode)OlapBuilderErrorCode.MONGODB_JSON_ERROR, new Serializable[]{"JSON", exception.getMessage()});
        }
    }

    protected static void validateIsJsonList(OlapBuilderValidationContext context, CdProperty prop, String value) {
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return;
        }
        try {
            OlapBuilderMongoDbTableRowReader.toBsonList(prop.getName(), "BsonList", value, true);
        }
        catch (RuntimeException exception) {
            context.addError(prop, (CdErrorCode)OlapBuilderErrorCode.MONGODB_JSON_ERROR, new Serializable[]{"JSON/JSONARRAY", exception.getMessage()});
        }
    }
}

