/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import com.iccube.bson.ic3BsonRow;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTablePartitionKey;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateDataTable;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class OlapBuilderMongoDbAggregateTableRowReader
extends OlapBuilderMongoDbTableRowReader<OlapBuilderMongoDbAggregateDataTable> {
    public OlapBuilderMongoDbAggregateTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderMongoDbAggregateDataTable table, String fullNameForEndUser, IOlapBuilderTablePartitionKey partitionKey) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
        this.partitionKey = (OlapBuilderAbstractTablePartitionKey)partitionKey;
    }

    static Document first(OlapBuilderMongoDbConnection connection, OlapBuilderMongoDbAggregateDataTable table) {
        MongoDatabase bd = connection.getMongoDataBase();
        MongoCollection collection = bd.getCollection(table.getCollection());
        AggregateIterable aggregateQuery = collection.aggregate(OlapBuilderMongoDbAggregateTableRowReader.toBsonList("aggr. pipeline", "BsonList", table.getPipeline()));
        if (table.getAllowDiskUse() != null) {
            aggregateQuery = aggregateQuery.allowDiskUse(table.getAllowDiskUse());
        }
        return (Document)aggregateQuery.first();
    }

    public void doInit() {
        List<Bson> pipeline;
        Comparable incrLoadMarker;
        this.initConnection();
        Comparable comparable = incrLoadMarker = this.context != null ? this.context.getIncrementalLoadMarker(this.table) : null;
        if (incrLoadMarker == null && this.partitionKey == null) {
            pipeline = OlapBuilderMongoDbAggregateTableRowReader.toBsonList("aggr. pipeline", "BsonList", ((OlapBuilderMongoDbAggregateDataTable)this.table).getPipeline());
        } else if (!((OlapBuilderMongoDbAggregateDataTable)this.table).hasQueryIncrLoadPart()) {
            Bson filters = this.getColumnBasedFilter(incrLoadMarker);
            pipeline = Collections.singletonList(Aggregates.match((Bson)filters));
        } else {
            String pipelineIncrLoad = ((OlapBuilderMongoDbAggregateDataTable)this.table).getPipelineIncrLoad(incrLoadMarker, this.partitionKey == null ? null : this.partitionKeyForReplacement());
            pipeline = OlapBuilderMongoDbAggregateTableRowReader.toBsonList("aggr. incr. pipeline", "BsonList", pipelineIncrLoad);
        }
        MongoCollection<Document> collection = this.getCollection(((OlapBuilderMongoDbAggregateDataTable)this.table).getCollection());
        AggregateIterable aggregateQuery = collection.aggregate(pipeline, ic3BsonRow.class);
        if (((OlapBuilderMongoDbAggregateDataTable)this.table).getBatchSize() != null) {
            aggregateQuery = aggregateQuery.batchSize(((OlapBuilderMongoDbAggregateDataTable)this.table).getBatchSize().intValue());
        }
        if (((OlapBuilderMongoDbAggregateDataTable)this.table).getAllowDiskUse() != null) {
            aggregateQuery = aggregateQuery.allowDiskUse(((OlapBuilderMongoDbAggregateDataTable)this.table).getAllowDiskUse());
        }
        this.result = aggregateQuery.iterator();
    }
}

