/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableResolvedRow;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateExDataTable;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateExTableDecoder;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbTableRowReader;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbAggregateExTableRowReader
extends OlapBuilderMongoDbTableRowReader<OlapBuilderMongoDbAggregateExDataTable> {
    private MongoCursor<?> result;
    private List<IOlapBuilderDataColumnDef> columns;

    public OlapBuilderMongoDbAggregateExTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderMongoDbAggregateExDataTable table, String fullNameForEndUser) {
        super(context, connectionPool, maxRowCount, table, fullNameForEndUser);
    }

    public void doInit() {
        this.initConnection();
        String collectionName = ((OlapBuilderMongoDbAggregateExDataTable)this.table).getCollection();
        MongoDatabase db = ((OlapBuilderMongoDbConnection)this.connection).getMongoClient().getDatabase(((OlapBuilderMongoDbDataSource)((OlapBuilderMongoDbConnection)this.connection).getDataSource()).getDbName());
        MongoCollection collection = db.getCollection(collectionName);
        List<Bson> pipeline = OlapBuilderMongoDbAggregateExTableRowReader.toBsonList("aggr. pipeline", "BsonList", ((OlapBuilderMongoDbAggregateExDataTable)this.table).getPipeline());
        AggregateIterable aggregateQuery = collection.aggregate(pipeline);
        if (((OlapBuilderMongoDbAggregateExDataTable)this.table).getBatchSize() != null) {
            aggregateQuery = aggregateQuery.batchSize(((OlapBuilderMongoDbAggregateExDataTable)this.table).getBatchSize().intValue());
        }
        if (((OlapBuilderMongoDbAggregateExDataTable)this.table).getAllowDiskUse() != null) {
            aggregateQuery = aggregateQuery.allowDiskUse(((OlapBuilderMongoDbAggregateExDataTable)this.table).getAllowDiskUse());
        }
        this.result = aggregateQuery.iterator();
    }

    @Override
    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (!this.result.hasNext()) {
            return null;
        }
        Object next = this.result.next();
        IOlapBuilderTableRow row = this.toBuilderRow(next);
        return row;
    }

    private IOlapBuilderTableRow toBuilderRow(Object next) {
        if (next instanceof Document) {
            return this.toBuilderRowFromDocument((Document)next);
        }
        throw new RuntimeException("unexpected MongoDB result [" + (next != null ? next.getClass().getName() : "<null>") + "+");
    }

    private IOlapBuilderTableRow toBuilderRowFromDocument(Document document) {
        if (this.columns == null) {
            this.columns = ((OlapBuilderMongoDbAggregateExDataTable)this.table).discoverAllColumns(document);
        }
        Comparable[] values = OlapBuilderMongoDbAggregateExTableDecoder.decode(this.columns, document);
        return new OlapBuilderTableResolvedRow(values);
    }

    @Override
    public void done() {
        if (this.result != null) {
            try {
                this.result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.done();
    }
}

