/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datatable.aggregate;

import crazydev.common.collection.CdComparableArray;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.type.IOlapBuilderInputTypeConverter;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.joda.time.Chronology;
import org.joda.time.LocalDateTime;
import org.joda.time.chrono.ISOChronology;

public abstract class OlapBuilderMongoDbAggregateExTableDecoder {
    private OlapBuilderMongoDbAggregateExTableDecoder() {
    }

    public static Comparable[] decode(List<IOlapBuilderDataColumnDef> columns, Document document) {
        Comparable[] values = new Comparable[columns.size()];
        for (int ii = 0; ii < columns.size(); ++ii) {
            IOlapBuilderDataColumnDef column = columns.get(ii);
            String[] path = column.getName().split("\\.");
            try {
                Comparable value;
                values[ii] = value = OlapBuilderMongoDbAggregateExTableDecoder.decodeJsonObject(document, column, path, 0);
                continue;
            }
            catch (Exception ex) {
                OlapLoggers.BUILDER.error((Object)"[MongoDB] unexpected processing error", (Throwable)ex);
                OlapLoggers.BUILDER.error((Object)("[MongoDB] -- document : \n" + document.toJson()));
                throw new OlapBuilderErrorException((Throwable)ex, OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{ex.getMessage()});
            }
        }
        return values;
    }

    private static Comparable decodeJsonObject(Object json, IOlapBuilderDataColumnDef column, String[] path, int pp) throws DecodeError {
        try {
            if (pp == path.length) {
                return OlapBuilderMongoDbAggregateExTableDecoder.decodeJsonObjectF(json, column, path, pp);
            }
            if (!(json instanceof Map)) {
                throw new DecodeError("unexpected JSON non-map");
            }
            String key = path[pp];
            Object obj = ((Map)json).get(key);
            if (obj instanceof List) {
                ArrayList<Comparable> arrValues = new ArrayList<Comparable>();
                List jsonARR = (List)obj;
                for (int ii = 0; ii < jsonARR.size(); ++ii) {
                    Object jsonITEM = jsonARR.get(ii);
                    Comparable jsonVALUE = OlapBuilderMongoDbAggregateExTableDecoder.decodeJsonObject(jsonITEM, column, path, pp + 1);
                    arrValues.add(jsonVALUE);
                }
                return new CdComparableArray(arrValues);
            }
            return OlapBuilderMongoDbAggregateExTableDecoder.decodeJsonObject(obj, column, path, pp + 1);
        }
        catch (DecodeError ex) {
            throw new DecodeError("error while decoding JSON object " + Arrays.toString(path) + "[" + pp + "]", ex);
        }
    }

    private static Comparable decodeJsonObjectF(Object json, IOlapBuilderDataColumnDef column, String[] path, int pp) throws DecodeError {
        if (json instanceof Map) {
            throw new DecodeError("unexpected JSON map " + Arrays.toString(path) + "[" + pp + "]");
        }
        Comparable value = json != null ? OlapBuilderMongoDbAggregateExTableDecoder.decodeJsonRawValue(column, json) : null;
        return value;
    }

    private static Comparable decodeJsonRawValue(IOlapBuilderDataColumnDef column, Object json) throws DecodeError {
        Object iValue;
        if (json instanceof ObjectId) {
            iValue = ((ObjectId)json).toHexString();
        } else if (json instanceof String) {
            iValue = json;
        } else if (json instanceof Number) {
            iValue = json;
        } else if (json instanceof Date) {
            iValue = new LocalDateTime(((Date)json).getTime(), (Chronology)ISOChronology.getInstanceUTC());
        } else {
            throw new DecodeError("unexpected JSON object type [" + (json != null ? json.getClass().getName() : "<null>") + "]");
        }
        OlapBuilderInputType type = column.getType();
        IOlapBuilderInputTypeConverter converter = type.getTypeConverter();
        Comparable value = converter.toJavaNativeValue(column.getName(), iValue);
        return value;
    }

    static class DecodeError
    extends Exception {
        private static final long serialVersionUID = 9108388412816419452L;

        public DecodeError(String message) {
            super(message);
        }

        public DecodeError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

