/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datasource;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.property.CdReadWriteProperty;
import crazydev.common.security.CdPassword;
import crazydev.common.utils.CdDefaultEnumerableForUi;
import crazydev.common.utils.CdEnumerableForUi;
import crazydev.common.utils.CdProperties;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdPasswordXmlAdapter;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.factory.schema.IOlapBuilderJaxbListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.def.IOlapBuilderValidationEnabled;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.builder.model.validation.OlapBuilderValidator;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbHelper;
import crazydev.iccube.builder.mongodb.common.OlapBuilderMongoDbLoggers;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbAuth;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbConnection;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSourceValidator;
import crazydev.iccube.builder.mongodb.datatable.aggregate.OlapBuilderMongoDbAggregateDataTable;
import crazydev.iccube.builder.mongodb.datatable.common.OlapBuilderMongoDbDataTable;
import crazydev.iccube.builder.mongodb.datatable.distinct.OlapBuilderMongoDbDistinctDataTable;
import crazydev.iccube.builder.mongodb.datatable.find.OlapBuilderMongoDbFindDataTable;
import crazydev.iccube.builder.mongodb.datatable.mapreduce.OlapBuilderMongoDbMapReduceDataTable;
import crazydev.iccube.builder.mongodb.error.OlapBuilderMongoDbErrorCode;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardStep;
import crazydev.iccube.builder.ux.meta.common.wizard.UxBuilderWizardValidation;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceType;
import crazydev.iccube.builder.ux.meta.datasource.UxBuilderDataSourceTypeGroupId;
import crazydev.iccube.builder.ux.meta.datasource.plugin.UxBuilderMongoDbConnectionType;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateDataSourceWizardSteps;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderCreateTypedDataSourceWizard;
import crazydev.iccube.builder.ux.meta.datasource.wizard.UxBuilderDataSourceNameForm;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.DateTimeZone;

@XmlRootElement(name="mongoDB-DS")
public class OlapBuilderMongoDbDataSource
extends OlapBuilderBaseDataSource<OlapBuilderMongoDbConnection>
implements IOlapBuilderJaxbListener {
    public static final CdProperty CONNECTIONSTRING = new CdReadWriteProperty(OlapBuilderMongoDbDataSource.class, "connectionString", false);
    public static final CdProperty DB_NAME = new CdReadWriteProperty(OlapBuilderMongoDbDataSource.class, "dbName", true);
    public static final CdProperty PASSWORD = new CdReadWriteProperty(OlapBuilderMongoDbDataSource.class, "password", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdPasswordXmlAdapter.class;
        }
    };
    public static final List<String> COMPRESSIONS = Arrays.asList("Snappy", "Zlib", "None");
    public static final CdProperty APPLY_DATE_TIME_TZ_TO_DATE = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbDataSource.class, "applyDateTimeTZtoDate", false);
    public static final CdProperty DATE_TIME_TZ = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbDataSource.class, "dateTimeTZ", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdEnumerableForUi.class;
        }

        public List<String> getPossibleValues(@Nullable Object modelOwner, @Nullable Object model) {
            return OlapBuilderMongoDbDataSource.getDateTimeTZAs();
        }

        public Object get(Object bean) {
            OlapBuilderMongoDbDataSource dataSource = (OlapBuilderMongoDbDataSource)((Object)bean);
            return dataSource.getDateTimeTZAsEnumerable();
        }
    };
    public static final CdProperty PROPERTIES = new CdReadWriteProperty("group.dataSourceAdvanced", OlapBuilderMongoDbDataSource.class, "properties", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdProperties.class;
        }
    };
    public static final CdProperty SERVER_NAME = new CdReadWriteProperty("group.formBase", OlapBuilderMongoDbDataSource.class, "serverName", false);
    public static final CdProperty PORT_NUMBER = new CdReadWriteProperty("group.formBase", OlapBuilderMongoDbDataSource.class, "portNumber", false);
    public static final CdProperty USER = new CdReadWriteProperty("group.formBase", OlapBuilderMongoDbDataSource.class, "user", false);
    public static final CdProperty COMPRESSION = new CdReadWriteProperty("group.formBase", OlapBuilderMongoDbDataSource.class, "compression", false){

        public Class<?> getTypeForDefaultEditor() {
            return CdEnumerableForUi.class;
        }

        public List<String> getPossibleValues(@Nullable Object modelOwner, @Nullable Object model) {
            return COMPRESSIONS;
        }

        public Object get(Object bean) {
            OlapBuilderMongoDbDataSource dataSource = (OlapBuilderMongoDbDataSource)((Object)bean);
            return new CdDefaultEnumerableForUi(dataSource.compression, COMPRESSIONS);
        }
    };
    public static final CdProperty AUTH_MECHANISM = new CdReadWriteProperty("group.formBase", OlapBuilderMongoDbDataSource.class, "authMechanism", false);
    static final List<Class<? extends IOlapBuilderTabularDataDef>> CREATED_TABLE_TYPES = Arrays.asList(OlapBuilderMongoDbAggregateDataTable.class, OlapBuilderMongoDbFindDataTable.class, OlapBuilderMongoDbDistinctDataTable.class);
    @XmlTransient
    @Nullable
    private final Object cachedAllCollectionNamesLOCK = new Object();
    @XmlAttribute(required=true)
    private String serverName;
    @XmlAttribute(required=false)
    private Integer portNumber;
    @XmlAttribute(required=true)
    private String dbName;
    @XmlAttribute(required=true)
    private String compression;
    @XmlAttribute(required=false)
    @Nullable
    private OlapBuilderMongoDbAuth authMechanism;
    @XmlAttribute(required=false)
    @Nullable
    private String user;
    @XmlJavaTypeAdapter(value=CdPasswordXmlAdapter.class)
    @XmlAttribute(required=false)
    @Nullable
    private CdPassword password;
    @XmlAttribute(required=false)
    @Nullable
    private String dateTimeTZ;
    @XmlAttribute(required=false)
    private boolean applyDateTimeTZtoDate;
    @XmlAttribute(required=false)
    @Nullable
    private String connectionString;
    @XmlElement(required=false)
    @Nullable
    private String properties = OlapBuilderMongoDbHelper.getDefaultSetting();
    @XmlElement(required=false)
    @Nullable
    private String savedCollections;
    @XmlTransient
    @Nullable
    private String cachedAllCollectionNamesKey;
    @XmlTransient
    @Nullable
    private volatile List<String> cachedAllCollectionNames;

    private OlapBuilderMongoDbDataSource() {
    }

    public OlapBuilderMongoDbDataSource(String name) {
        super(name);
    }

    public UxBuilderDataSourceTypeGroupId getUxGroupId() {
        return UxBuilderDataSourceTypeGroupId.dsTypeGroupNoSql;
    }

    protected String getReportDataSourceType() {
        return "mongoDB";
    }

    protected String getReportDataSourceTypeCaption() {
        return "MongoDB";
    }

    public void beforeMarshal() {
    }

    public void afterUnmarshal() {
        if (CdStringUtils.isNullOrBlank((String)this.properties)) {
            this.properties = OlapBuilderMongoDbHelper.getDefaultSetting();
        }
    }

    @Nullable
    public String getCompression() {
        return this.compression;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPortNumber() {
        return this.portNumber != null ? this.portNumber : 27017;
    }

    public String getDbName() {
        return this.dbName;
    }

    public OlapBuilderMongoDbAuth getAuthMechanism() {
        if (this.authMechanism == null) {
            return OlapBuilderMongoDbAuth.DEFAULT;
        }
        return this.authMechanism;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @Nullable
    public String getPassword() {
        return this.password != null ? this.password.clear : null;
    }

    @Nullable
    public String getProperties() {
        return this.properties;
    }

    public MongoClientSettings.Builder getOptions(MongoClientSettings.Builder optionsBuilder, int serverSelectionTimeout) {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.properties)) {
            try {
                Properties asProperties = new Properties();
                asProperties.load(new StringReader(this.properties));
                for (Map.Entry<Object, Object> entry : asProperties.entrySet()) {
                    String name = (String)entry.getKey();
                    int value = Integer.valueOf((String)entry.getValue());
                    OlapBuilderMongoDbHelper.applySettings(optionsBuilder, name, value);
                }
                if (serverSelectionTimeout > 0) {
                    OlapBuilderMongoDbHelper.applySettings(optionsBuilder, "cluster.serverSelectionTimeout", serverSelectionTimeout);
                }
            }
            catch (IOException | RuntimeException ex) {
                OlapLoggers.BUILDER.error((Object)"MongoDB connection options error", (Throwable)ex);
                throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{ex.getMessage()});
            }
        }
        return optionsBuilder;
    }

    public boolean isDiscoverTablesSupported() {
        return false;
    }

    @Nullable
    public List<Class<? extends IOlapBuilderTabularDataDef>> getCreatedTableTypes() {
        return CREATED_TABLE_TYPES;
    }

    public OlapBuilderBaseDataTable<OlapBuilderMongoDbConnection> createEmptyCreateTable(@Nullable Class<IOlapBuilderTabularDataDef> tableType) {
        OlapBuilderMongoDbDataTable table;
        if (OlapBuilderMongoDbAggregateDataTable.class.equals(tableType)) {
            table = new OlapBuilderMongoDbAggregateDataTable();
        } else if (OlapBuilderMongoDbFindDataTable.class.equals(tableType)) {
            table = new OlapBuilderMongoDbFindDataTable();
        } else if (OlapBuilderMongoDbMapReduceDataTable.class.equals(tableType)) {
            table = new OlapBuilderMongoDbMapReduceDataTable();
        } else if (OlapBuilderMongoDbDistinctDataTable.class.equals(tableType)) {
            table = new OlapBuilderMongoDbDistinctDataTable();
        } else {
            throw new RuntimeException("internal error : unexpected MongoDB table type [" + (tableType != null ? tableType.getSimpleName() : "n/a") + "]");
        }
        table.setDataSource((IOlapBuilderDataSource)this);
        return table;
    }

    private String getKeyForCache() {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.connectionString)) {
            return this.connectionString;
        }
        return this.serverName + this.portNumber + this.dbName + this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCollectionNamesForUi() {
        String key = this.getKeyForCache();
        Object object = this.cachedAllCollectionNamesLOCK;
        synchronized (object) {
            List<String> cachedNames = this.cachedAllCollectionNames;
            String cachedNamesKey = this.cachedAllCollectionNamesKey;
            if (cachedNames != null && cachedNamesKey != null && cachedNamesKey.equals(key)) {
                return cachedNames;
            }
            if (CdStringUtils.isNullOrBlank((String)this.savedCollections)) {
                try (OlapBuilderMongoDbConnection conn = new OlapBuilderMongoDbConnection(this);){
                    conn.open(null);
                    List<String> names = conn.getCollectionNames();
                    this.cacheCollectionNames(this.getKeyForCache(), names);
                }
            }
            if (!this.savedCollections.isEmpty()) {
                return Arrays.asList(this.savedCollections.split("\\."));
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheCollectionNames(String key, List<String> tables) {
        Object object = this.cachedAllCollectionNamesLOCK;
        synchronized (object) {
            this.cachedAllCollectionNamesKey = key;
            this.cachedAllCollectionNames = tables;
            this.savedCollections = String.join((CharSequence)".", this.cachedAllCollectionNames);
        }
    }

    public OlapBuilderValidator<IOlapBuilderValidationEnabled, IOlapBuilderDataSource> getValidator() {
        return new OlapBuilderMongoDbDataSourceValidator();
    }

    public List<String> discoverAllTablesNames(OlapBuilderMongoDbConnection connection, boolean filterSystemSchemas, @Nullable String filter) {
        try {
            List<String> names = connection.getCollectionNames();
            this.cacheCollectionNames(this.getKeyForCache(), names);
            return names;
        }
        catch (MongoException ex) {
            OlapBuilderMongoDbLoggers.GENERAL.error((Object)"[MongoDB] unexpected error", (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    public OlapBuilderMongoDbConnection createConnection(OlapRuntimeContext context, boolean forceRefresh) {
        return this.createConnection();
    }

    public OlapBuilderMongoDbConnection createConnection() {
        return new OlapBuilderMongoDbConnection(this);
    }

    public boolean refreshCachedEntities(OlapBuilderMongoDbConnection connection) {
        List<String> tables;
        try {
            tables = this.discoverAllTablesNames(connection, true, null);
        }
        catch (Exception ignored) {
            return false;
        }
        String key = this.getKeyForCache();
        this.cacheCollectionNames(key, tables);
        return true;
    }

    public boolean applyDateTimeTZtoDate() {
        return this.applyDateTimeTZtoDate;
    }

    @Nullable
    public DateTimeZone getDateTimeTZ() {
        if (CdStringUtils.isNullOrBlank((String)this.dateTimeTZ)) {
            return null;
        }
        try {
            DateTimeZone tz = DateTimeZone.forID((String)this.dateTimeTZ);
            return tz;
        }
        catch (IllegalArgumentException ex) {
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{"Unexpected date timezone ID [" + this.dateTimeTZ + "]!"});
        }
    }

    private CdEnumerableForUi getDateTimeTZAsEnumerable() {
        return new CdDefaultEnumerableForUi(this.dateTimeTZ, OlapBuilderMongoDbDataSource.getDateTimeTZAs());
    }

    public static List<String> getDateTimeTZAs() {
        return CdJodaTimeUtil.availableIDs();
    }

    @Nullable
    public String getDecodedConnectionString() {
        if (CdStringUtils.isNotNullAndNotBlank((String)this.connectionString)) {
            return this.connectionString.replace("<password>", this.password != null ? this.password.clear : "");
        }
        return null;
    }

    protected UxBuilderDataSourceType createUxType() {
        String id = ((Object)((Object)this)).getClass().getSimpleName();
        return new UxBuilderDataSourceType(id, this.getUxTypeImage(), () -> new UxBuilderCreateTypedDataSourceWizard(this, id, this.createUxCreateWizardSteps()){
            {
                Objects.requireNonNull(this$0);
                super(arg0, arg1);
            }

            public UxBuilderWizardValidation validate(OlapRuntimeContext context, int activeStep) {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                UxBuilderMongoDbConnectionType type = (UxBuilderMongoDbConnectionType)((UxBuilderWizardStep)this.steps.get(1)).getModel();
                if (activeStep == 1) {
                    return new UxBuilderWizardValidation(activeStep, switch (type.getConnectionType()) {
                        case UxBuilderMongoDbConnectionType.ConnectionType.FormBased -> this.doFormBased(name.getName());
                        case UxBuilderMongoDbConnectionType.ConnectionType.ConnectionStringOnly -> this.doConnectionString(name.getName());
                        default -> throw new CdShouldNotBeHereProgrammingException();
                    });
                }
                if (activeStep == 2) {
                    OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource)((Object)((UxBuilderWizardStep)this.steps.get(2)).getModel());
                    if (type.getConnectionType() == UxBuilderMongoDbConnectionType.ConnectionType.ConnectionStringOnly) {
                        OlapBuilderErrorManager errorMgr = new OlapBuilderErrorManager(true);
                        OlapBuilderMongoDbDataSourceValidator.validateConnectionString(errorMgr, ds.getDecodedConnectionString());
                    }
                    return new UxBuilderWizardValidation(activeStep);
                }
                throw new CdShouldNotBeHereProgrammingException("" + activeStep);
            }

            private List<UxBuilderWizardStep> doConnectionString(String name) {
                ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
                OlapBuilderMongoDbDataSource dataSource = new OlapBuilderMongoDbDataSource(name);
                newSteps.add(UxBuilderCreateDataSourceWizardSteps.propsInclude((boolean)true, (Object)((Object)dataSource), (CdProperty[])new CdProperty[]{DB_NAME, CONNECTIONSTRING, PASSWORD}));
                return newSteps;
            }

            private List<UxBuilderWizardStep> doFormBased(String name) {
                ArrayList<UxBuilderWizardStep> newSteps = new ArrayList<UxBuilderWizardStep>();
                OlapBuilderMongoDbDataSource dataSource = new OlapBuilderMongoDbDataSource(name);
                newSteps.add(UxBuilderCreateDataSourceWizardSteps.propsExclude((boolean)true, (Object)((Object)dataSource), (CdProperty[])new CdProperty[]{NAME, DESCRIPTION, CONNECTIONSTRING}));
                return newSteps;
            }

            public IOlapBuilderDataSource getDataSourceFromUI() {
                UxBuilderDataSourceNameForm name = (UxBuilderDataSourceNameForm)((UxBuilderWizardStep)this.steps.get(0)).getModel();
                OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource)((Object)((UxBuilderWizardStep)this.steps.get(2)).getModel());
                ds.setNameAndDescription(name.getName(), name.getDescription());
                return ds;
            }
        });
    }

    protected List<UxBuilderWizardStep> createUxCreateWizardSteps() {
        ArrayList<UxBuilderWizardStep> steps = new ArrayList<UxBuilderWizardStep>();
        steps.add(UxBuilderCreateDataSourceWizardSteps.name());
        steps.add(UxBuilderCreateDataSourceWizardSteps.create((String)"wizard.createDataSource.mongodb.connectionType", (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (Object)new UxBuilderMongoDbConnectionType(UxBuilderMongoDbConnectionType.ConnectionType.ConnectionStringOnly)));
        return steps;
    }
}

