/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.mongodb.datasource;

import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.datasource.OlapBuilderAbstractConnection;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbAuth;
import crazydev.iccube.builder.mongodb.datasource.OlapBuilderMongoDbDataSource;
import crazydev.iccube.builder.mongodb.error.OlapBuilderMongoDbErrorCode;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OlapBuilderMongoDbConnection
extends OlapBuilderAbstractConnection<OlapBuilderMongoDbDataSource> {
    private MongoClient mongoClient;
    @Nullable
    private MongoDatabase mongoDatabase;

    public OlapBuilderMongoDbConnection(OlapBuilderMongoDbDataSource dataSource) {
        super((OlapBuilderBaseDataSource)dataSource);
    }

    @Nullable
    private static char[] password(@Nullable String password) {
        return password != null ? password.toCharArray() : null;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    public MongoDatabase getMongoDataBase() {
        if (this.mongoDatabase == null) {
            this.mongoDatabase = this.mongoClient.getDatabase(((OlapBuilderMongoDbDataSource)this.dataSource).getDbName());
        }
        return this.mongoDatabase;
    }

    protected void checkOnOpenConnectionEx() throws OlapBuilderErrorException {
        try {
            BasicDBObject buildInfo = new BasicDBObject("buildInfo", (Object)1);
            Document commandResult = this.getMongoDataBase().runCommand((Bson)buildInfo);
            String string = commandResult.getString((Object)"version");
        }
        catch (MongoException ex) {
            OlapLoggers.BUILDER.error((Object)"MongoDB connection error", (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    protected void onOpen(@Nullable OlapRuntimeContext context) throws OlapBuilderErrorException {
        this.mongoClient = this.createMongoClient(-1);
    }

    private MongoClient createMongoClient(int serverSelectionTimeout) {
        String password;
        OlapBuilderMongoDbDataSource ds = (OlapBuilderMongoDbDataSource)this.getDataSource();
        String database = ds.getDbName();
        String userName = ds.getUser();
        if (CdStringUtils.isNullOrBlank((String)userName)) {
            userName = null;
        }
        if (CdStringUtils.isNullOrBlank((String)(password = ds.getPassword()))) {
            password = null;
        }
        try {
            String connectionString = ds.getDecodedConnectionString();
            MongoClient mongoClient = CdStringUtils.isNotNullAndNotBlank((String)connectionString) ? MongoClients.create((String)connectionString) : this.buildMongoClient(ds, database, userName, password, serverSelectionTimeout);
            return mongoClient;
        }
        catch (MongoException ex) {
            OlapLoggers.BUILDER.error((Object)"MongoDB connection error", (Throwable)ex);
            throw new OlapBuilderErrorException(OlapBuilderMongoDbErrorCode.ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    @NotNull
    private MongoClient buildMongoClient(OlapBuilderMongoDbDataSource ds, String database, String userName, String password, int serverSelectionTimeout) {
        MongoClientSettings.Builder clientBuilder = ds.getOptions(MongoClientSettings.builder(), serverSelectionTimeout);
        MongoCredential credential = userName != null ? this.getCredentials(ds, database, userName, password) : null;
        if ("snappy".equalsIgnoreCase(ds.getCompression())) {
            clientBuilder = clientBuilder.compressorList(Collections.singletonList(MongoCompressor.createSnappyCompressor()));
        }
        if ("zlib".equalsIgnoreCase(ds.getCompression())) {
            clientBuilder = clientBuilder.compressorList(Collections.singletonList(MongoCompressor.createZlibCompressor()));
        }
        if (credential != null) {
            clientBuilder.credential(credential);
        }
        String connectionString = "mongodb://" + new ServerAddress(ds.getServerName(), ds.getPortNumber()).toString();
        MongoClientSettings clientSettings = clientBuilder.applyConnectionString(new ConnectionString(connectionString)).build();
        return MongoClients.create((MongoClientSettings)clientSettings);
    }

    private MongoCredential getCredentials(OlapBuilderMongoDbDataSource ds, String database, String userName, String password) {
        OlapBuilderMongoDbAuth authMechanism = ds.getAuthMechanism();
        switch (authMechanism) {
            case DEFAULT: {
                return MongoCredential.createCredential((String)userName, (String)database, (char[])OlapBuilderMongoDbConnection.password(password));
            }
            case SCRAM_SHA_1: {
                return MongoCredential.createScramSha1Credential((String)userName, (String)database, (char[])OlapBuilderMongoDbConnection.password(password));
            }
            case CR: {
                return MongoCredential.createMongoCRCredential((String)userName, (String)database, (char[])OlapBuilderMongoDbConnection.password(password));
            }
            case X509: {
                return MongoCredential.createMongoX509Credential((String)userName);
            }
            case GSSAPI: {
                return MongoCredential.createGSSAPICredential((String)userName);
            }
            case PLAIN: {
                return MongoCredential.createPlainCredential((String)userName, (String)database, (char[])OlapBuilderMongoDbConnection.password(password));
            }
        }
        throw new RuntimeException("internal error: unexpected authentication [" + authMechanism.name() + "]");
    }

    protected void onClose() {
        if (this.mongoClient != null) {
            this.mongoClient.close();
        }
    }

    public List<String> getCollectionNames() {
        MongoIterable iter = this.mongoClient.getDatabase(((OlapBuilderMongoDbDataSource)this.dataSource).getDbName()).listCollectionNames();
        ArrayList<String> names = new ArrayList<String>();
        iter.forEach(names::add);
        return names;
    }
}

