/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson;

import com.iccube.bson.decoder.ic3BsonArrayDecoder;
import com.iccube.bson.decoder.ic3BsonBinary;
import com.iccube.bson.decoder.ic3BsonBooleanDecoder;
import com.iccube.bson.decoder.ic3BsonDateTimeDecoder;
import com.iccube.bson.decoder.ic3BsonDecimal128Decoder;
import com.iccube.bson.decoder.ic3BsonDecoder;
import com.iccube.bson.decoder.ic3BsonDocumentDecoder;
import com.iccube.bson.decoder.ic3BsonDoubleDecoder;
import com.iccube.bson.decoder.ic3BsonEmptyDecoder;
import com.iccube.bson.decoder.ic3BsonEndDocumentDecoder;
import com.iccube.bson.decoder.ic3BsonIntDecoder;
import com.iccube.bson.decoder.ic3BsonJavascriptWithScopeDecoder;
import com.iccube.bson.decoder.ic3BsonLongDecoder;
import com.iccube.bson.decoder.ic3BsonNullDecoder;
import com.iccube.bson.decoder.ic3BsonObjectIdDecoder;
import com.iccube.bson.decoder.ic3BsonRegularExpressionDecoder;
import com.iccube.bson.decoder.ic3BsonStringDecoder;
import com.iccube.bson.decoder.ic3BsonTimeStampDecoder;
import org.jetbrains.annotations.NotNull;

public enum ic3BsonType {
    END_OF_DOCUMENT(0, new ic3BsonEndDocumentDecoder()),
    DOUBLE(1, new ic3BsonDoubleDecoder()),
    STRING(2, new ic3BsonStringDecoder()),
    DOCUMENT(3, new ic3BsonDocumentDecoder()),
    ARRAY(4, new ic3BsonArrayDecoder()),
    BINARY(5, new ic3BsonBinary()),
    UNDEFINED(6, new ic3BsonEmptyDecoder()),
    OBJECT_ID(7, new ic3BsonObjectIdDecoder()),
    BOOLEAN(8, new ic3BsonBooleanDecoder()),
    DATE_TIME(9, new ic3BsonDateTimeDecoder()),
    NULL(10, new ic3BsonNullDecoder()),
    REGULAR_EXPRESSION(11, new ic3BsonRegularExpressionDecoder()),
    DB_POINTER(12, new ic3BsonStringDecoder()),
    JAVASCRIPT(13, new ic3BsonStringDecoder()),
    SYMBOL(14, new ic3BsonStringDecoder()),
    JAVASCRIPT_WITH_SCOPE(15, new ic3BsonJavascriptWithScopeDecoder()),
    INT32(16, new ic3BsonIntDecoder()),
    TIMESTAMP(17, new ic3BsonTimeStampDecoder()),
    INT64(18, new ic3BsonLongDecoder()),
    DECIMAL128(19, new ic3BsonDecimal128Decoder()),
    MIN_KEY(255, new ic3BsonEmptyDecoder()),
    MAX_KEY(127, new ic3BsonEmptyDecoder());

    private static final ic3BsonType[] LOOKUP_TABLE;
    private final int value;
    private final ic3BsonDecoder decoder;

    private ic3BsonType(int value, ic3BsonDecoder decoder) {
        this.value = value;
        this.decoder = decoder;
        if (decoder == null) {
            throw new RuntimeException("No decoder for " + Integer.toHexString(value));
        }
    }

    @NotNull
    public static ic3BsonType findExistingType(int value) {
        ic3BsonType type = LOOKUP_TABLE[value & 0xFF];
        if (type == null) {
            throw new RuntimeException("Type not found " + Integer.toHexString(value));
        }
        return type;
    }

    int getValue() {
        return this.value;
    }

    public boolean isContainer() {
        return this == DOCUMENT || this == ARRAY;
    }

    public ic3BsonDecoder getDecoder() {
        return this.decoder;
    }

    static {
        LOOKUP_TABLE = new ic3BsonType[MIN_KEY.getValue() + 1];
        ic3BsonType[] ic3BsonTypeArray = ic3BsonType.values();
        int n = ic3BsonTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ic3BsonType cur;
            ic3BsonType.LOOKUP_TABLE[cur.getValue()] = cur = ic3BsonTypeArray[i];
        }
    }
}

