/*
 * Decompiled with CFR 0.152.
 */
package com.iccube.bson;

import com.iccube.bson.ic3BsonStringBuilder;
import com.iccube.bson.ic3BsonType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.bson.types.ObjectId;

public class ic3BsonBytesBuffer {
    public final byte[] bytes;
    private final Map<ic3BsonStringBuilder, String> cacheCString;
    private final boolean cacheStringValues;
    public int pos;

    public ic3BsonBytesBuffer(Map<ic3BsonStringBuilder, String> cacheCString, byte[] bytes, boolean cacheStringValues) {
        this.cacheCString = cacheCString;
        this.bytes = bytes;
        this.pos = 0;
        this.cacheStringValues = cacheStringValues;
    }

    private static int makeInt(byte b0, byte b1, byte b2, byte b3) {
        return b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | b3 << 24;
    }

    private static long makeLong(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }

    public ic3BsonType getType() {
        return ic3BsonType.findExistingType(this.bytes[this.pos++]);
    }

    public String getFieldName() {
        ic3BsonStringBuilder.StringAndLength ret = ic3BsonStringBuilder.getOrCreateString(this.cacheCString, this.bytes, this.pos);
        this.pos += ret.bytesLength + 1;
        return ret.str;
    }

    public String getCName() {
        int pos = this.pos;
        while (this.bytes[++pos] != 0) {
        }
        return this.createCString(this.pos, pos - this.pos);
    }

    public String getString() {
        int size = this.getInt();
        String name = this.createCString(this.pos, size - 1);
        this.pos += size;
        return name;
    }

    private String createCString(int initialPos, int fSize) {
        if (this.cacheStringValues) {
            return ic3BsonStringBuilder.getOrCreateString(this.cacheCString, (byte[])this.bytes, (int)initialPos).str;
        }
        byte[] nbytes = new byte[fSize];
        System.arraycopy(this.bytes, initialPos, nbytes, 0, fSize);
        String fieldName = new String(nbytes, StandardCharsets.UTF_8);
        return fieldName;
    }

    public int getInt() {
        return ic3BsonBytesBuffer.makeInt(this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++]);
    }

    public long getLong() {
        return ic3BsonBytesBuffer.makeLong(this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++], this.bytes[this.pos++]);
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public boolean getBoolean() {
        return this.bytes[this.pos++] != 0;
    }

    public void skip(int byteNumber) {
        this.pos += byteNumber;
    }

    public void skipFieldName() {
        while (this.bytes[this.pos++] != 0) {
        }
    }

    public ObjectId getObjectId() {
        ByteBuffer buffer = ByteBuffer.wrap(this.bytes, this.pos, 12);
        this.pos += 12;
        return new ObjectId(buffer);
    }

    public byte[] slice() {
        return Arrays.copyOfRange(this.bytes, this.pos, this.bytes.length);
    }
}

