/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.tidy.serialize;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.ICdException;
import crazydev.common.javacompiler.CompilationException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.OlapResDrillthroughStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetT;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetTpp;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreSerializer;
import crazydev.iccube.olap.eval.exception.OlapJavaNativeCompilationEvaluationException;
import crazydev.iccube.olap.eval.rest.RestResultStoreReferenceKey;
import crazydev.iccube.olap.eval.rest.RestResultStoreSerializer;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapPostProcessedMdxResult;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.tidytable.info.MdxInfoTidyTable;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxJavaNativeError;
import crazydev.iccube.ux.common.validation.UxJavaNativeErrors;
import crazydev.iccube.ux.common.validation.UxMdxRange;
import crazydev.iccube.ux.mdx.queries.tidyExecute.result.UxTidyExecuteMdxError;
import crazydev.iccube.ux.tidy.serialize.UxTidyExecuteMdxScriptWritableResult;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxTidySerializerUtils {
    private UxTidySerializerUtils() {
    }

    public static UxReply asMdxReply(UxQueryContext context, @Nullable OlapResultCacheInfo<RestResultStoreReferenceKey> resultCacheInfo, @Nullable OlapResultStoreInformation info, boolean json, boolean flat, boolean infos, List<OlapResStatementDataSet> results) throws IOException {
        IOlapSerializedTidyResource resource = UxTidySerializerUtils.serializeAsJson(context, json, flat, infos, results);
        if (resultCacheInfo != null && resultCacheInfo.isCacheWriteEnabled()) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            resource.write((OutputStream)bytes);
            RestResultStoreReferenceKey resultKey = (RestResultStoreReferenceKey)resultCacheInfo.getResultKey();
            RestResultStoreSerializer resultSerializer = new RestResultStoreSerializer(info, bytes.toByteArray());
            OlapResultCache resultCache = resultCacheInfo.getResultCache();
            OlapEngineRequestContext engineRequestContext = context.getOlapEngineRequestContext();
            if (resultCache.addResult(engineRequestContext, (OlapResultStoreReferenceKey)resultKey, (OlapResultStoreSerializer)resultSerializer)) {
                engineRequestContext.onDetailAdded("MDX (cache)", "Result stored into cache");
                if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
                    OlapLoggers.MDX_EVALUATION_RESULT_CACHE.debug((Object)("[result-cache] MDX " + engineRequestContext.getRequestId().getId() + " result stored into cache"));
                }
            }
        }
        return UxReply.actionSuccess(new UxTidyExecuteMdxScriptWritableResult(resource));
    }

    public static UxReply asMdxReplyFromCache(UxQueryContext context, OlapResultStoreDeSerializer result) throws IOException {
        OlapEngineRequestContext engineRequestContext = context.getOlapEngineRequestContext();
        IOlapSerializedTidyResource resource = OlapSerializedTidyResourceFactory.create((OlapSerializedTidyResourceFactory.Prefix)OlapSerializedTidyResourceFactory.Prefix.mdx, (OlapEngineRequestContext)engineRequestContext, arg_0 -> ((OlapResultStoreDeSerializer)result).read(arg_0));
        return UxReply.actionSuccess(new UxTidyExecuteMdxScriptWritableResult(resource));
    }

    private static IOlapSerializedTidyResource serializeAsJson(UxQueryContext context, boolean json, boolean flat, boolean infos, List<OlapResStatementDataSet> results) throws IOException {
        OlapEngineRequestContext eContext = context.getOlapEngineRequestContext();
        return OlapSerializedTidyResourceFactory.create((OlapSerializedTidyResourceFactory.Prefix)OlapSerializedTidyResourceFactory.Prefix.mdx, (OlapEngineRequestContext)eContext, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            w.beginObject();
            UxTidySerializerUtils.serializeResults(w, gson, context, json, flat, infos, results);
            w.endObject();
            w.close();
        });
    }

    private static void serializeResults(JsonWriter w, Gson g, UxQueryContext context, boolean json, boolean flat, boolean infos, List<OlapResStatementDataSet> results) throws IOException {
        if (results.size() > 1 && infos) {
            w.name("infos");
            w.beginArray();
            for (OlapResStatementDataSet result : results) {
                w.beginObject();
                OlapResScriptInfo info = result.asScriptResultInfo((CdBabylonService)context.getOlapBabylonService());
                w.name("error");
                w.value(result.isError());
                w.name("type");
                w.value(info.getType());
                w.name("details");
                w.value(info.getDetails());
                w.endObject();
            }
            w.endArray();
        } else {
            w.name("results");
            w.beginArray();
            for (OlapResStatementDataSet result : results) {
                w.beginObject();
                UxTidySerializerUtils.serializeResult(w, g, context, json, flat, result);
                w.endObject();
            }
            w.endArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeResult(JsonWriter w, Gson g, UxQueryContext context, boolean json, boolean flat, OlapResStatementDataSet result) throws IOException {
        long start = System.nanoTime();
        try {
            if (result.isError()) {
                w.name("error");
                UxTidySerializerUtils.serializeError(w, g, context, result.getException());
            } else {
                w.name("dataSet");
                UxTidySerializerUtils.serializeDataSet(w, g, context, json, flat, result);
            }
        }
        finally {
            if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
                OlapLoggers.UX_REQUEST.debug((Object)("[UX] MDX data-set serialization : " + CdTimeUtils.formatNanosEx((long)start)));
            }
        }
    }

    private static void serializeDataSet(JsonWriter w, Gson g, UxQueryContext context, boolean json, boolean flat, OlapResStatementDataSet result) throws IOException {
        if (result instanceof OlapResSelectStatementDataSetT) {
            OlapResSelectStatementDataSetT sDataSet = (OlapResSelectStatementDataSetT)result;
            OlapResMdxTidyTable table = sDataSet.getTable();
            table.serializeTable(w, g, context.getOlapEngineRequestContext(), json, flat, null, null, sDataSet.getExecutionTimeMS());
        } else if (result instanceof OlapResSelectStatementDataSetTpp) {
            OlapResSelectStatementDataSetTpp sDataSet = (OlapResSelectStatementDataSetTpp)result;
            OlapPostProcessedMdxResult table = sDataSet.getTable();
            table.serializeTable(w, g, context.getOlapEngineRequestContext(), json, flat, null);
        } else if (result instanceof OlapResDrillthroughStatementDataSet) {
            OlapResDrillthroughStatementDataSet dDataSet = (OlapResDrillthroughStatementDataSet)result;
            OlapDrillthroughCollection collection = dDataSet.getCollection();
            Integer tidyMaxRowCount = dDataSet.getTidyMaxRowCount();
            Boolean tidyMaxRowCountReached = dDataSet.getTidyMaxRowCountReached();
            collection.serializeTable(w, g, context.getOlapEngineRequestContext(), json, tidyMaxRowCount != null ? tidyMaxRowCount : Integer.MAX_VALUE, tidyMaxRowCountReached != null ? tidyMaxRowCountReached : false, null);
        } else {
            OlapResScriptInfo info = result.asScriptResultInfo((CdBabylonService)context.getOlapBabylonService());
            boolean error = result.isError();
            String type = info.getType();
            String details = info.getDetails();
            MdxInfoTidyTable table = new MdxInfoTidyTable(type, details, error);
            String tableJ = g.toJson((Object)table);
            w.jsonValue(tableJ);
        }
    }

    private static void serializeError(JsonWriter w, Gson g, UxQueryContext context, ICdException exception) throws IOException {
        UxJavaNativeErrors javaNativeErrors = null;
        if (exception instanceof OlapJavaNativeCompilationEvaluationException) {
            OlapJavaNativeCompilationEvaluationException jException = (OlapJavaNativeCompilationEvaluationException)exception;
            ArrayList<UxJavaNativeError> errors = new ArrayList<UxJavaNativeError>();
            for (CompilationException.Error compilationError : jException.getCompilationErrors()) {
                errors.add(new UxJavaNativeError(compilationError.getLineNumber(), compilationError.getStartPosition(), compilationError.getEndPosition(), compilationError.getErrorMessage()));
            }
            if (!errors.isEmpty()) {
                javaNativeErrors = new UxJavaNativeErrors(jException.getSourceCode(), errors);
            }
        }
        CdError error = exception.getError();
        UxMdxRange range = UxUtils.setupMdxRange(0, error.getLocation());
        String errorCode = error.getCode().getValue();
        String errorMessage = error.asMessage((CdBabylonService)context.getOlapBabylonService());
        UxTidyExecuteMdxError uxError = new UxTidyExecuteMdxError(errorCode, errorMessage, range, javaNativeErrors);
        String uxErrorJ = g.toJson((Object)uxError);
        w.jsonValue(uxErrorJ);
    }
}

