/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor.servlet;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.http.IcCubeServlet;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxOlapBabylonService;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;

public class UxRestApiServlet
extends IcCubeServlet {
    public static final String URL = "/icCube/api";
    public static final String ENTRY_POINT = "/icCube/api/*";
    private static final long serialVersionUID = 4083057690482712714L;

    public String getEntryPoint() {
        return ENTRY_POINT;
    }

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.REST_API;
    }

    @Override
    protected void doHandle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (OlapLoggers.UX_REQUEST_URL.isDebugEnabled()) {
            OlapLoggers.UX_REQUEST_URL.debug((Object)("[UX] (api) servlet [" + request.getRequestURI() + "]"));
        }
        IcCubeServerApplicationContext appContext = this.getAppContext();
        UxRequestProcessor processor = appContext.getUxRequestProcessor();
        try {
            processor.processUxRequest(UxApi.REST, request, response);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"UX request : unexpected error", (Throwable)ex);
            UxReply reply = UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"UX request error : " + ex.getMessage()}));
            reply.writeResponse(UxBabylonService.ENGLISH(UxApi.REST), request, response, UxApi.REST);
        }
    }

    public static boolean processGviRequest(UxRestApiServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean rest;
        String reporting = request.getHeader("X-REPORTING");
        String command = request.getHeader("X-REPORTING-COMMAND");
        boolean bl = rest = "ic3".equalsIgnoreCase(reporting) && CdStringUtils.isNotNullAndNotBlank((String)command);
        if (rest) {
            servlet.doHandle((HttpServletRequest)new GviRestHttpRequest(request), response);
            return true;
        }
        return false;
    }

    static class GviRestHttpRequest
    extends HttpServletRequestWrapper {
        private final String command;

        public GviRestHttpRequest(HttpServletRequest request) {
            super(request);
            this.command = request.getHeader("X-REPORTING-COMMAND");
        }

        protected HttpServletRequest getHttpServletRequest() {
            return (HttpServletRequest)super.getRequest();
        }

        public String getPathInfo() {
            return "/" + this.command;
        }
    }
}

