/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor.servlet;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.server.http.IcCubeServlet;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxOlapBabylonService;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;

public class UxApiServlet
extends IcCubeServlet {
    private static final long serialVersionUID = -719655617543201558L;

    public String getEntryPoint() {
        return "/icCube/ux-api/*";
    }

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.UX_API;
    }

    @Override
    protected void doHandle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (OlapLoggers.UX_REQUEST_URL.isDebugEnabled()) {
            OlapLoggers.UX_REQUEST_URL.debug((Object)("[UX] (ux-api) servlet [" + request.getRequestURI() + "]"));
        }
        IcCubeServerApplicationContext appContext = this.getAppContext();
        UxRequestProcessor processor = appContext.getUxRequestProcessor();
        try {
            processor.processUxRequest(UxApi.UX, request, response);
        }
        catch (IOException | RuntimeException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"UX request : unexpected error", (Throwable)ex);
            UxReply reply = UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"UX request error : " + ex.getMessage()}));
            reply.writeResponse(UxBabylonService.ENGLISH(UxApi.UX), request, response, UxApi.UX);
        }
    }
}

