/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor.servlet;

import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.server.authentication.IcCubeAbstractAuthenticationServletFilter;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxErrorReplyPayload;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.payload.UxReplyStatus;
import crazydev.iccube.ux.processor.UxBabylonService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;

public class UxApiDefaultAuthenticationServletFilter
extends IcCubeAbstractAuthenticationServletFilter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        OlapPrincipal icCubePrincipal;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        if (session != null && (icCubePrincipal = (OlapPrincipal)session.getAttribute("icCube.principal")) != null) {
            if (OlapLoggers.AUTHENTICATION.isDebugEnabled()) {
                OlapLoggers.AUTHENTICATION.debug((Object)("[UX] (ux-api) [" + icCubePrincipal.getName() + "] [" + icCubePrincipal.getRoleName() + "]"));
            }
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        UxApiDefaultAuthenticationServletFilter.replyNotAuthUxApi(request, response);
    }

    protected static void replyNotAuthUxApi(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UxPayloadReply reply = new UxPayloadReply(UxReplyStatus.ERROR, new UxErrorReplyPayload(UxErrorCode.NOT_AUTHORIZED_REFRESH.getValue(), "not authorized (please refresh your browser)"));
        reply.writeResponse(UxBabylonService.ENGLISH(UxApi.UX), request, response, UxApi.UX);
    }
}

