/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor.conf;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="static")
public class UxStaticComponentConfiguration {
    @XmlElementRef(type=IParam.class)
    private List<IParam> params;
    @XmlElement(name="filter", required=true)
    private List<String> filters;

    public void validate() throws OlapConfigurationException {
        if (this.filters == null || this.filters.isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"UX (static) authentication filter"});
        }
        for (String filter : this.filters) {
            if (!CdStringUtils.isNullOrBlank((String)filter)) continue;
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"UX (static) authentication filter"});
        }
    }

    @Nullable
    public String getInitParameter(String name) {
        if (this.params != null) {
            for (IParam param : this.params) {
                if (!param.name.equals(name)) continue;
                return param.value;
            }
        }
        return null;
    }

    public List<String> getFilterConfiguration() {
        return this.filters;
    }

    @XmlRootElement(name="param")
    public static class IParam {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;
    }
}

