/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderEntityUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.common.filter.UxFilterValue;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableSortType;
import crazydev.iccube.ux.processor.UxServerDecompressedRequestParams;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class UxServerRequestParams {
    @Nullable
    private final HttpServletRequest httpRequest;
    private final UxServerDecompressedRequestParams params;
    private volatile OlapRequestId requestId;

    public UxServerRequestParams(@Nullable HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
        this.params = new UxServerDecompressedRequestParams(httpRequest);
    }

    public void logout() {
        if (this.httpRequest != null) {
            try {
                this.httpRequest.logout();
            }
            catch (ServletException ex) {
                OlapLoggers.REQUESTS.error((Object)"HTTP request logout error", (Throwable)ex);
            }
            HttpSession session = this.httpRequest.getSession();
            if (session != null) {
                session.invalidate();
            }
        }
    }

    public OlapRequestId getRequestId() {
        if (this.requestId == null) {
            throw new RuntimeException("internal error: missing request-id");
        }
        return this.requestId;
    }

    public void setRequestId(OlapRequestId requestId) {
        this.requestId = requestId;
    }

    public InputStream getInputStream() throws IOException {
        if (this.httpRequest == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return this.httpRequest.getInputStream();
    }

    public String getPathInfo() {
        if (this.httpRequest == null) {
            return "";
        }
        return this.httpRequest.getPathInfo();
    }

    @Nullable
    public String getHeader(String name) {
        if (this.httpRequest == null) {
            return null;
        }
        return this.httpRequest.getHeader(name);
    }

    public UxModel getExistingModelParameter(String name) throws UxQueryParserException {
        UxModel value = this.getModelParameter(name);
        if (value == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return value;
    }

    @Nullable
    public UxModel getModelParameter(String name) throws UxQueryParserException {
        return this.params.getModelParameter(name);
    }

    @Nullable
    public UxDocsEntryPath getPathParameter(String name) throws UxQueryParserException {
        return this.params.getPathParameter(name);
    }

    @Nullable
    public UxSchemaId getSchemaIdParameter() {
        String schemaName = this.getStringParameter("schemaName");
        String schemaFile = this.getStringParameter("schemaFile");
        if (CdStringUtils.isNullOrBlank((String)schemaName) && CdStringUtils.isNullOrBlank((String)schemaFile)) {
            return null;
        }
        return new UxSchemaId(schemaName, schemaFile);
    }

    public UxSchemaId getExistingSchemaIdParameter() throws UxQueryParserException {
        UxSchemaId schemaId = this.getSchemaIdParameter();
        if (schemaId == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{"schemaName|schemaFile"});
        }
        return schemaId;
    }

    @Nullable
    public UxBuilderTablePathName getTableNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderTablePathName.createFromUrlParam(name, value);
    }

    public UxBuilderTablePathName getExistingTableNameParameter(String name) throws UxQueryParserException {
        UxBuilderTablePathName tableName = this.getTableNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderCubeUniqueName getCubeNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderCubeUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderCubeUniqueName getExistingCubeNameParameter(String name) throws UxQueryParserException {
        UxBuilderCubeUniqueName tableName = this.getCubeNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderMeasureGroupUniqueName getMeasureGroupNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderMeasureGroupUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderMeasureGroupUniqueName getExistingMeasureGroupNameParameter(String name) throws UxQueryParserException {
        UxBuilderMeasureGroupUniqueName tableName = this.getMeasureGroupNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderMeasureUniqueName getMeasureNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderMeasureUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderMeasureUniqueName getExistingMeasureNameParameter(String name) throws UxQueryParserException {
        UxBuilderMeasureUniqueName tableName = this.getMeasureNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderDimensionUniqueName getDimensionNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderDimensionUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderDimensionUniqueName getExistingDimensionNameParameter(String name) throws UxQueryParserException {
        UxBuilderDimensionUniqueName tableName = this.getDimensionNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderHierarchyUniqueName getHierarchyNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderHierarchyUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderHierarchyUniqueName getExistingHierarchyNameParameter(String name) throws UxQueryParserException {
        UxBuilderHierarchyUniqueName tableName = this.getHierarchyNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public UxBuilderLevelUniqueName getLevelNameParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            return null;
        }
        return UxBuilderLevelUniqueName.createFromUrlParam(name, value);
    }

    public UxBuilderLevelUniqueName getExistingLevelNameParameter(String name) throws UxQueryParserException {
        UxBuilderLevelUniqueName tableName = this.getLevelNameParameter(name);
        if (tableName == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return tableName;
    }

    @Nullable
    public List<UxBuilderEntityUniqueName> getSchemaEntityNamesParameter(String name) throws UxQueryParserException {
        Object value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList<UxBuilderEntityUniqueName> names = new ArrayList<UxBuilderEntityUniqueName>();
            for (Object obj : values) {
                if (!(obj instanceof Map)) continue;
                Map fields = (Map)obj;
                Object type = fields.get("type");
                Object uuid = fields.get("uuid");
                if (!(type instanceof String)) continue;
                String typeS = (String)type;
                if (!(uuid instanceof String)) continue;
                String uuidS = (String)uuid;
                names.add(new UxBuilderEntityUniqueName(typeS, uuidS));
            }
            return names;
        }
        throw new UxQueryParserException(UxErrorCode.PARAM_TYPE_MISMATCH, new Serializable[]{name, value.getClass().getSimpleName(), "list"});
    }

    @Nullable
    public Object getParameter(String name) {
        return this.params.getParameter(name);
    }

    @Nullable
    public Object getExistingParameter(String name) throws UxQueryParserException {
        Object param = this.getParameter(name);
        if (param == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return param;
    }

    @Nullable
    public String getInfoParameter() {
        return this.getStringParameter("ic3_Info");
    }

    public String getStringParameter(String name, String defaultValue) {
        String param = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)param)) {
            return defaultValue;
        }
        return param;
    }

    @Nullable
    public String getStringParameter(String name) {
        return this.params.getStringParameter(name);
    }

    public String getExistingStringParameter(String name) throws UxQueryParserException {
        String value = this.getStringParameter(name);
        if (CdStringUtils.isNullOrBlank((String)value)) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return value;
    }

    public List<String> getExistingStringsParameter(String name) throws UxQueryParserException {
        List<String> strs = this.getStringsParameter(name);
        if (strs == null || strs.isEmpty()) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return strs;
    }

    @Nullable
    public List<String> getStringsParameter(String name) {
        return this.params.getStringsParameter(name);
    }

    public boolean getBooleanParameter(String name) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (CdStringUtils.isNotNullAndNotBlank((String)param)) {
            try {
                return Boolean.parseBoolean(param);
            }
            catch (RuntimeException ex) {
                throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, param});
            }
        }
        return false;
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (CdStringUtils.isNotNullAndNotBlank((String)param)) {
            try {
                return Boolean.parseBoolean(param);
            }
            catch (RuntimeException ex) {
                throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, param});
            }
        }
        return defaultValue;
    }

    public int getExistingIntegerParameter(String name) throws UxQueryParserException {
        Integer value = this.getIntegerParameter(name);
        if (value == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return value;
    }

    @Nullable
    public Integer getIntegerParameter(String name) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (CdStringUtils.isNotNullAndNotBlank((String)param)) {
            return UxServerRequestParams.asIntValue(name, param);
        }
        return null;
    }

    public int getIntegerParameter(String name, int defaultValue) throws UxQueryParserException {
        Integer value = this.getIntegerParameter(name);
        return value != null ? value : defaultValue;
    }

    public List<Integer> getExistingIntegersParameter(String name) throws UxQueryParserException {
        List<Integer> ints = this.getIntegersParameter(name);
        if (ints == null || ints.isEmpty()) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return ints;
    }

    @Nullable
    public List<Integer> getIntegersParameter(String name) throws UxQueryParserException {
        return this.params.getIntegersParameter(name);
    }

    public long getExistingLongParameter(String name) throws UxQueryParserException {
        Long value = this.getLongParameter(name);
        if (value == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return value;
    }

    @Nullable
    public Long getLongParameter(String name) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (CdStringUtils.isNotNullAndNotBlank((String)param)) {
            return UxServerRequestParams.asLongValue(name, param);
        }
        return null;
    }

    @Nullable
    public <T extends Enum<T>> T getEnumParameter(Class<T> clazz, String name) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (param == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, param);
        }
        catch (IllegalArgumentException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, param});
        }
    }

    @Nullable
    public <T extends Enum<T>> T getEnumParameter(Class<T> clazz, String name, T defaultValue) throws UxQueryParserException {
        String param = this.getStringParameter(name);
        if (param == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, param);
        }
        catch (IllegalArgumentException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, param});
        }
    }

    public <T extends Enum<T>> T getExistingEnumParameter(Class<T> clazz, String name) throws UxQueryParserException {
        T value = this.getEnumParameter(clazz, name);
        if (value == null) {
            throw new UxQueryParserException(UxErrorCode.PARAM_MISSING, new Serializable[]{name});
        }
        return value;
    }

    public UxTableOptions getTableOptions() throws UxQueryParserException {
        Integer pageSize;
        Integer page;
        UxTableSortType order;
        String orderBy = this.getStringParameter("orderBy");
        String order_ = this.getStringParameter("order");
        try {
            order = CdStringUtils.isNotNullAndNotBlank((String)order_) ? UxTableSortType.valueOf(order_) : null;
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{"order", order_});
        }
        String page_ = this.getStringParameter("page");
        try {
            page = CdStringUtils.isNotNullAndNotBlank((String)page_) ? Integer.valueOf(page_) : null;
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{"page", page_});
        }
        String pageSize_ = this.getStringParameter("pageSize");
        try {
            pageSize = CdStringUtils.isNotNullAndNotBlank((String)pageSize_) ? Integer.valueOf(pageSize_) : null;
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{"pageSize", pageSize_});
        }
        String searchText = this.getStringParameter("searchText");
        ArrayList<UxFilterValue> filters = null;
        List<String> filters_ = this.getStringsParameter("filter");
        if (filters_ != null) {
            for (String filter_ : filters_) {
                UxFilterValue filter = UxFilterValue.create(filter_);
                if (filter == null) continue;
                if (filters == null) {
                    filters = new ArrayList<UxFilterValue>();
                }
                filters.add(filter);
            }
        }
        return UxTableOptions.create(orderBy, order, page, pageSize, null, searchText, filters);
    }

    public static int asIntValue(String name, String value) throws UxQueryParserException {
        try {
            double asDouble = Double.parseDouble(value);
            int asInt = (int)asDouble;
            if (asDouble == (double)asInt) {
                return asInt;
            }
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, value});
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, value});
        }
    }

    public static long asLongValue(String name, String value) throws UxQueryParserException {
        try {
            double asDouble = Double.parseDouble(value);
            long asInt = (long)asDouble;
            if (asDouble == (double)asInt) {
                return asInt;
            }
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, value});
        }
        catch (RuntimeException ex) {
            throw new UxQueryParserException(UxErrorCode.PARAM_UNEXPECTED_VALUE, new Serializable[]{name, value});
        }
    }
}

