/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.tests.CdTestUtils;
import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.version.CdVersion;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.pub.utils.ic3CSRFUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.executor.IcCubeServerTaskExecutor;
import crazydev.iccube.server.request.processor.common.IcCubeRequestProcessor;
import crazydev.iccube.tenants.OlapTenantDefinition;
import crazydev.iccube.tenants.OlapTenantManager;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryExpectedException;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.query.UxQueryParserHelper;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxOlapBabylonService;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.processor.UxServerRequest;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import crazydev.iccube.ux.processor.UxServerRequestReply;
import crazydev.iccube.ux.processor.conf.UxApiComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxRequestProcessor
extends IcCubeRequestProcessor<UxReply, UxServerRequest, UxServerRequestReply, UxServerRequestContext> {
    private final boolean apiWithCSRF;

    public UxRequestProcessor(@Nullable UxComponentConfiguration configuration, IcCubeServerTaskExecutor taskExecutor, IcCubeRequestStatusManager statusManager) {
        super(taskExecutor, statusManager);
        UxApiComponentConfiguration apiConfiguration = configuration != null ? configuration.getUxApiConf() : null;
        this.apiWithCSRF = apiConfiguration != null && apiConfiguration.isWithCSRF();
    }

    private UxServerRequestContext setupRequestContext(HttpServletRequest httpRequest, UxServerRequest request) {
        IcCubeServerSessionContext sessionContext = IcCubeServerSessionContext.getOrCreateSessionContext(httpRequest);
        return new UxServerRequestContext(sessionContext, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUxRequest(UxApi api, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        try {
            this.doProcessUxRequest(api, httpRequest, httpResponse);
        }
        finally {
            HttpSession session;
            if (api == UxApi.REST && (session = httpRequest.getSession(false)) != null) {
                String console = httpRequest.getHeader("X-CONSOLE");
                String reporting = httpRequest.getHeader("X-REPORTING");
                if (!"ic3".equalsIgnoreCase(console) && !"ic3".equalsIgnoreCase(reporting)) {
                    session.invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessUxRequest(UxApi api, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        UxReply reply;
        UxServerRequestContext requestContext;
        UxServerRequest request;
        httpRequest.setCharacterEncoding("UTF-8");
        UxServerRequestParams params = new UxServerRequestParams(httpRequest);
        UxAppType appType = null;
        try {
            appType = params.getEnumParameter(UxAppType.class, "appType");
        }
        catch (UxQueryParserException uxQueryParserException) {
            // empty catch block
        }
        String navTreeUUID = params.getStringParameter("navTreeUUID");
        String ic3_clt_req_uuid = params.getStringParameter("ic3_clt_req_uuid");
        OlapRequestId requestId = OlapRequestId.getThreadRequestId((String)ic3_clt_req_uuid);
        params.setRequestId(requestId);
        try {
            String iTenant;
            String value;
            UxQuery query = UxQueryParserHelper.parseQuery(params);
            String windowUId = params.getStringParameter("windowUId");
            if (CdStringUtils.isNotNullAndNotBlank((String)windowUId)) {
                String widgetUId = params.getStringParameter("widgetUId");
                Long timestamp = params.getLongParameter("timestamp");
                query.setGviInfo(windowUId, widgetUId, timestamp);
            }
            if (CdStringUtils.isNotNullAndNotBlank((String)(value = params.getStringParameter("version")))) {
                query.setVersion(CdVersion.create((String)value));
            }
            String verbosity = params.getStringParameter(OlapRequestVerbosity.VERBOSITY());
            query.setVerbosity(OlapRequestVerbosity.fromParam((String)verbosity));
            String clientLocale = httpRequest.getHeader("ic3_client_locale");
            if (CdStringUtils.isNullOrBlank((String)clientLocale)) {
                clientLocale = params.getStringParameter("locale");
            }
            Locale locale = CdLocaleUtils.fromName((String)clientLocale);
            String builderSnapshot = httpRequest.getHeader("ic3_builder_snapshot");
            request = new UxServerRequest(api, locale, appType, navTreeUUID, httpRequest, query);
            request.setBuilderSnapshot(builderSnapshot);
            requestContext = this.setupRequestContext(httpRequest, request);
            if (requestContext.isForRestApi() && requestContext.isSuperAdministrator() && CdStringUtils.isNotNullAndNotBlank((String)(iTenant = params.getStringParameter("iTenant")))) {
                OlapTenantManager tenants = requestContext.getTenantManager();
                OlapTenantDefinition tenantDefinition = tenants.getTenantDefinitionByName(iTenant);
                if (tenantDefinition == null) {
                    UxReply response = UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.TENANT_UNKNOWN, (Serializable[])new Serializable[]{iTenant}));
                    response.writeResponse(this.createEnglishBabylonServiceUx(api), httpRequest, httpResponse, api);
                    return;
                }
                OlapTenant tenant = new OlapTenant(tenantDefinition.getName(), tenantDefinition.getDirectory());
                requestContext.resetUserTenant(tenant);
            }
            query.initialize(requestContext);
        }
        catch (UxQueryParserException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] unexpected malformed request", (Throwable)((Object)ex));
            UxReply response = UxReply.error(UxOlapBabylonService.ENGLISH, ex.getError());
            response.writeResponse(this.createEnglishBabylonServiceUx(api), httpRequest, httpResponse, api);
            return;
        }
        catch (UxQueryExpectedException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] request error", (Throwable)ex);
            UxReply response = UxReply.error(UxOlapBabylonService.ENGLISH, ex.getError());
            response.writeResponse(this.createEnglishBabylonServiceUx(api), httpRequest, httpResponse, api);
            return;
        }
        if (!this.validateCSRFToken(api, request)) {
            UxReply response = UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"CSRF error (please refresh your browser)"}));
            response.writeResponse(this.createEnglishBabylonServiceUx(api), httpRequest, httpResponse, api);
            return;
        }
        try {
            reply = this.processUxRequest(requestContext, request);
        }
        catch (UxQueryExpectedException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] request error", (Throwable)ex);
            UxReply response = UxReply.error(UxOlapBabylonService.ENGLISH, ex.getError());
            response.writeResponse(this.createEnglishBabylonServiceUx(api), httpRequest, httpResponse, api);
            return;
        }
        try {
            reply.writeResponse(requestContext.getUxBabylonService(), httpRequest, httpResponse, api);
        }
        finally {
            reply.release();
        }
    }

    private boolean validateCSRFToken(UxApi api, UxServerRequest request) {
        if (CdTestUtils.CSRF_TOKEN_VALIDATION_OFF) {
            return true;
        }
        if (api == UxApi.UX) {
            return this.validateCSRFTokenApi(request);
        }
        return true;
    }

    private boolean validateCSRFTokenApi(UxServerRequest request) {
        if (!this.apiWithCSRF) {
            return true;
        }
        if (request.ignoreCSRFToken()) {
            return true;
        }
        String sessionToken = request.getCSRFSessionToken();
        if (CdStringUtils.isNullOrBlank((String)sessionToken)) {
            OlapLoggers.REQUEST.error((Object)("[UX] CSRF: unexpected missing session token for: " + request.toStringForCSRFError()));
            return false;
        }
        String requestToken = request.getCSRFHeaderToken();
        if (CdStringUtils.isNullOrBlank((String)requestToken)) {
            OlapLoggers.REQUEST.error((Object)("[UX] CSRF: unexpected missing request token for: " + request.toStringForCSRFError()));
            return false;
        }
        if (!ic3CSRFUtils.equals((String)sessionToken, (String)requestToken)) {
            OlapLoggers.REQUEST.error((Object)("[UX] CSRF: unexpected request token value [request:" + requestToken + "] [session:" + sessionToken + "] for: " + request.toStringForCSRFError()));
            return false;
        }
        return true;
    }

    private UxReply processUxRequest(UxServerRequestContext context, UxServerRequest request) {
        try {
            UxReply response = (UxReply)this.processXyzRequest(context, request);
            return response;
        }
        catch (RuntimeException unexpected) {
            UxReply response = this.createUnexpectedUnexpectedResponse(request, unexpected);
            return response;
        }
    }

    @Override
    protected UxReply createSuccessResponse(UxServerRequestContext requestContext, UxServerRequest request, UxServerRequestReply reply) {
        UxReply response = reply.getResponse();
        if (response == null) {
            throw new RuntimeException("internal error : UX reply inconsistency");
        }
        return response;
    }

    @Override
    protected UxReply createCancelledResponse(UxServerRequestContext requestContext, UxServerRequest request, boolean onTimeout, @Nullable String extraInfo) {
        CdError error = CdError.create((CdErrorCode)(!onTimeout ? UxErrorCode.CANCELLED : UxErrorCode.TIMEOUT), (Serializable[])new Serializable[0]);
        return UxReply.error(requestContext::getBabylonService, error, extraInfo);
    }

    @Override
    protected UxReply createExceptionResponseEx(UxServerRequestContext requestContext, UxServerRequest request, Throwable exception) {
        if (exception instanceof OlapRoleAuthorizationRuntimeException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationRuntimeException)exception);
        }
        if (exception instanceof OlapRoleAuthorizationException) {
            return this.createNotAuthorizedResponse(requestContext, request, (OlapRoleAuthorizationException)exception);
        }
        if (exception instanceof UxQueryParserException) {
            return this.createParserErrorResponse(requestContext, request, (UxQueryParserException)((Object)exception));
        }
        if (exception instanceof UxQueryExpectedException) {
            return this.createExpectedErrorResponse(requestContext, request, (UxQueryExpectedException)exception);
        }
        return this.createUnexpectedUnexpectedResponse(request, exception);
    }

    private UxReply createNotAuthorizedResponse(UxServerRequestContext requestContext, UxServerRequest request, OlapRoleAuthorizationRuntimeException exception) {
        OlapLoggers.UX_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        return UxReply.error(requestContext, CdError.create((CdErrorCode)UxErrorCode.NOT_AUTHORIZED, (Serializable[])new Serializable[]{exception.getError().asMessage((CdBabylonService)requestContext.getBabylonService())}));
    }

    private UxReply createNotAuthorizedResponse(UxServerRequestContext requestContext, UxServerRequest request, OlapRoleAuthorizationException exception) {
        OlapLoggers.UX_REQUEST.error((Object)(request.getLoggerInfo() + " : not authorized"), (Throwable)exception);
        return UxReply.error(requestContext, CdError.create((CdErrorCode)UxErrorCode.NOT_AUTHORIZED, (Serializable[])new Serializable[]{exception.getError().asMessage((CdBabylonService)requestContext.getBabylonService())}));
    }

    private UxReply createParserErrorResponse(UxServerRequestContext requestContext, UxServerRequest request, UxQueryParserException exception) {
        OlapLoggers.UX_REQUEST.error((Object)(request.getLoggerInfo() + " : unexpected malformed request"), (Throwable)((Object)exception));
        return UxReply.error(requestContext, exception.getError());
    }

    private UxReply createExpectedErrorResponse(UxServerRequestContext requestContext, UxServerRequest request, UxQueryExpectedException exception) {
        OlapLoggers.UX_REQUEST.error((Object)(request.getLoggerInfo() + " : request error"), (Throwable)exception);
        return UxReply.error(requestContext, exception.getError());
    }

    private UxReply createUnexpectedUnexpectedResponse(UxServerRequest request, Throwable unexpected) {
        OlapLoggers.UX_REQUEST.error((Object)(request.getLoggerInfo() + " : unexpected processing error"), unexpected);
        return UxReply.error(UxOlapBabylonService.ENGLISH, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{unexpected.getMessage()}));
    }

    @Override
    protected UxReply createMissingReplyResponse(UxServerRequestContext requestContext, UxServerRequest request) {
        return UxReply.error(requestContext, CdError.create((CdErrorCode)UxErrorCode.ERROR_UNEXPECTED, (Serializable[])new Serializable[]{"unexpected missing request reply"}));
    }
}

