/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdBabylonUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.reply.UxApi;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class UxBabylonService
extends CdBabylonService {
    protected static final String DESCRIPTION_UX = ".descriptionUx";
    private final UxApi api;
    private final Locale locale;
    private final OlapBabylonService builder;

    public UxBabylonService(UxApi api, Locale locale) {
        this.api = api;
        this.locale = locale == null ? Locale.ENGLISH : locale;
        this.builder = new OlapBabylonService(this.locale);
    }

    public static UxBabylonService ENGLISH(UxApi api) {
        return new UxBabylonService(api, Locale.ENGLISH);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String translate_(boolean isForRestApi, String tag) {
        if (isForRestApi) {
            return tag;
        }
        return this.translate(tag, new Serializable[0]);
    }

    public String translate(String tag, Serializable ... params) {
        String localized = CdBabylonUtils.translate((Set)this.missings, (Locale)this.locale, ((Object)((Object)this)).getClass(), Collections.emptyList(), (String)tag, (Serializable[])params);
        if (localized != tag) {
            return localized;
        }
        return this.builder.translate(tag, params);
    }

    public String translateUseCaseGroup(String tag) {
        return this.translate("useCase.group." + tag, new Serializable[0]);
    }

    public int translateUseCaseGroupOrder(String tag) {
        Integer order = this.getOrder("useCase.group." + tag);
        return order != null ? order : -1;
    }

    @Nullable
    public String translateUseCaseCaptionEx(String tag, Serializable ... params) {
        String tag_ = "useCase.caption.ex." + tag;
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    public String translateActionCaption(String tag, Serializable ... params) {
        return this.translate("action.caption." + tag, params);
    }

    @Nullable
    public String translateActionCaptionEx(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".ex";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    @Nullable
    public String translateActionCaptionSearch(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".search";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    @Nullable
    public String translateActionTitle(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".title";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    @Nullable
    public String translateActionSynopsis(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".synopsis";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    @Nullable
    public String translateActionProcessingInfo(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".processingInfo";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    @Nullable
    public String translateActionNoticeText(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".noticeText";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return null;
        }
        return localized;
    }

    public String translateActionOkCancel(String tag, Serializable ... params) {
        String tag_ = "action.caption." + tag + ".okCancel";
        String localized = this.translate(tag_, params);
        if (localized.equals(tag_)) {
            return "Please confirm you'd like to proceed?";
        }
        return localized;
    }

    public String translateModelTypeCaption(String typePersistentId) {
        return this.translate("uxModelType.caption." + typePersistentId, new Serializable[0]);
    }

    public String translateModelPropertyCaption(String prefix, String name) {
        Object tag = prefix + "." + name;
        String label = this.translate((String)tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        tag = name;
        label = this.translate((String)tag, new Serializable[0]);
        return label;
    }

    @Nullable
    public UxHelpText translateWizardDescription(String id) {
        String tag = id + ".description";
        String description = this.translate(tag, new Serializable[0]);
        if (description != tag) {
            return UxBabylonService.processHelpText(description);
        }
        return null;
    }

    @Nullable
    public UxHelpText translateModelPropertyDescription(String name) {
        return this.translateModelPropertyDescription(null, name);
    }

    @Nullable
    public UxHelpText translateModelPropertyDescription(@Nullable String prefix, String name) {
        String tag = (String)(prefix != null ? prefix + "." : "") + name + DESCRIPTION_UX;
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return UxBabylonService.processHelpText(label);
        }
        tag = name + DESCRIPTION_UX;
        label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return UxBabylonService.processHelpText(label);
        }
        tag = (String)(prefix != null ? prefix + "." : "") + name + ".description";
        label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return UxBabylonService.processHelpText(label);
        }
        tag = name + ".description";
        label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return UxBabylonService.processHelpText(label);
        }
        return null;
    }

    @Nullable
    public static UxHelpText processHelpText(@Nullable String label) {
        return UxHelpText.create(label);
    }

    public String translateEnum(Class<?> enumType, String name) {
        if (this.api == UxApi.REST) {
            return name;
        }
        return super.translateEnum(enumType, name);
    }

    public String translateEnumCaption(Class<?> enumType, String tag) {
        return this.translateEnum(enumType, tag);
    }

    @Nullable
    public UxHelpText translateEnumDescriptionEx(Class<?> enumType, String name) {
        if (this.api == UxApi.REST) {
            return null;
        }
        return UxBabylonService.processHelpText(super.translateEnumDescription(enumType, name));
    }

    public int translateEnumOrder(Class<?> enumType, String tag) {
        Integer order = this.getOrder(enumType.getSimpleName() + "." + tag);
        return order != null ? order : -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        UxBabylonService that = (UxBabylonService)((Object)o);
        return this.api == that.api && Objects.equals(this.locale, that.locale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.api, this.locale});
    }
}

