/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.tidyExecute;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.ICdException;
import crazydev.common.javacompiler.CompilationException;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptExecutionInfo;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptErrorDataSet;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCache;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreDeSerializer;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.iccube.olap.eval.exception.OlapJavaNativeCompilationEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.rest.RestResultStoreReferenceKey;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.common.IOlapProtocol;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxExecuteScriptI;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.common.validation.UxJavaNativeError;
import crazydev.iccube.ux.common.validation.UxJavaNativeErrors;
import crazydev.iccube.ux.common.validation.UxMdxRange;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.tidyExecute.result.UxTidyExecuteMdxError;
import crazydev.iccube.ux.mdx.queries.tidyExecute.result.UxTidyExecuteMdxScriptResult;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import crazydev.iccube.ux.tidy.serialize.UxTidySerializerUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class UxTidyExecuteMdxScriptQuery
extends UxMdxConsoleQuery
implements UxExecuteScriptI {
    private final boolean json;
    private final boolean flat;
    private final boolean infos;
    private final String schemaName;
    private final String scriptName = "n/a";
    private final String scriptHash = UUID.randomUUID().toString();
    private final String script;
    @Nullable
    private final Integer tidyMaxRowCount;
    private final boolean reportingMF;
    private final boolean debug = false;

    protected UxTidyExecuteMdxScriptQuery(UxQueryMeta meta, OlapRequestId requestId, boolean json, boolean flat, boolean infos, String schemaName, String script, @Nullable Integer tidyMaxRowCount, boolean reportingMF) {
        super(meta, requestId);
        this.json = json;
        this.flat = flat;
        this.infos = infos;
        this.schemaName = schemaName;
        this.script = script;
        this.tidyMaxRowCount = tidyMaxRowCount;
        this.reportingMF = reportingMF;
    }

    @Override
    public String getSchema() {
        return this.schemaName;
    }

    @Override
    public String getScriptName() {
        return "n/a";
    }

    @Override
    public String getMdxHash() {
        return this.scriptHash;
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public boolean isForDebug() {
        return false;
    }

    @Override
    public boolean isMonitored() {
        return true;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.MDX;
    }

    @Override
    public String getMdxForCancelReport() {
        return this.script;
    }

    @Override
    public boolean isMonitoredForTimeout() {
        return true;
    }

    @Override
    public void setupMdxRequestProperties(OlapEngineRequestContext requestContext) {
        List mdxDefaultRequestedCellProperties = this.reportingMF ? OlapIntrinsicCellProperties.DEFAULT_EX : null;
        requestContext.setupMdxRequestProperties(this.reportingMF, mdxDefaultRequestedCellProperties, true, this.tidyMaxRowCount, null, null, null);
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String requestId = "" + this.getRequestId().getId();
        boolean scriptOffset = false;
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        engineRequestContext.onMdxDetailAdded("MDX", this.schemaName, this.script);
        OlapEngineMdxScriptCompilationInfo compilationInfo = queryContext.getMdxCompilationInfo();
        OlapResScriptDataSet compilationResult = compilationInfo.getResult();
        if (compilationResult != null) {
            OlapEngineMdxHelper mdxHelper = compilationInfo.getHelper();
            OlapInstrExecListener listener = mdxHelper.getInstrExecListener();
            return UxTidyExecuteMdxScriptQuery.asReply(queryContext, requestId, 0, listener, null, this.json, this.flat, this.infos, compilationResult);
        }
        OlapScriptInstr scriptInstr = compilationInfo.getScriptInstr();
        if (scriptInstr == null) {
            throw new RuntimeException("internal error: missing MDX script evaluation instruction");
        }
        List statements = scriptInstr.getStatements();
        if (statements.isEmpty()) {
            return UxReply.actionSuccess(UxTidyExecuteMdxScriptResult.empty(requestId));
        }
        OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
        OlapSchema schema = olapEngine.getAuthorizedSchema(engineRequestContext, scriptInstr.getSchemaAccessLockMode(), this.schemaName);
        if (schema == null) {
            OlapBabylonService babylon = queryContext.getOlapBabylonService();
            String message = babylon.translate("schemaNotFound", new Serializable[]{this.schemaName});
            return UxReply.actionSuccess(UxTidyExecuteMdxScriptResult.createFromError(requestId, new UxTidyExecuteMdxError(OlapErrorCode.SCHEMA_MISSING.getValue(), message)));
        }
        OlapResultCacheInfo resultCacheInfo = new OlapResultCacheInfo();
        UxReply cached = this.executeFromCache(queryContext, (OlapResultCacheInfo<RestResultStoreReferenceKey>)resultCacheInfo, compilationInfo, schema);
        if (cached != null) {
            return cached;
        }
        long startNS = System.nanoTime();
        OlapEngineMdxScriptExecutionInfo executionInfo = compilationInfo.asExecutionInfo();
        OlapEngineMdxHelper mdxHelper = compilationInfo.getHelper();
        OlapInstrExecListener listener = mdxHelper.getInstrExecListener();
        OlapResScriptDataSet debuggerResult = null;
        if (listener != null) {
            try {
                listener.assertExecution(executionInfo.getScriptInstr());
            }
            catch (OlapException ex) {
                debuggerResult = new OlapResScriptErrorDataSet(executionInfo.getName(), schema.getName(), (ICdException)ex);
            }
        }
        OlapResScriptDataSet result = debuggerResult == null ? mdxHelper.executeMdxScriptUX(executionInfo, schema) : debuggerResult;
        if (OlapLoggers.UX_REQUEST.isDebugEnabled()) {
            OlapLoggers.UX_REQUEST.debug((Object)("[UX] MDX : " + CdTimeUtils.formatNanosEx((long)startNS)));
        }
        return UxTidyExecuteMdxScriptQuery.asReply(queryContext, requestId, 0, listener, (OlapResultCacheInfo<RestResultStoreReferenceKey>)resultCacheInfo, this.json, this.flat, this.infos, result);
    }

    @Nullable
    private UxReply executeFromCache(UxQueryContext context_, OlapResultCacheInfo<RestResultStoreReferenceKey> resultCacheInfo, OlapEngineMdxScriptCompilationInfo compilationInfo, OlapSchema schema) {
        String prefix;
        boolean cache;
        resultCacheInfo.setSchema(schema);
        OlapEngineRequestContext context = context_.getOlapEngineRequestContext();
        OlapResultCache resultCache = context.getOrCreateResultCache(IOlapProtocol.REST_API, schema);
        if (resultCache == null) {
            return null;
        }
        int cacheCount = 0;
        int noCacheCount = 0;
        OlapResScriptDataSet result = compilationInfo.getResult();
        OlapScriptInstr instr = compilationInfo.getScriptInstr();
        if (result == null && instr != null) {
            List statements = instr.getStatements();
            for (OlapStatementInstr statement : statements) {
                if (statement.isResultCacheEnabled()) {
                    ++cacheCount;
                    continue;
                }
                ++noCacheCount;
            }
        }
        boolean bl = cache = cacheCount > 0 && noCacheCount == 0;
        if (!cache) {
            return null;
        }
        resultCacheInfo.setResultCache(resultCache);
        RestResultStoreReferenceKey resultKey = new RestResultStoreReferenceKey(this.script, this.json, this.flat, this.infos, this.tidyMaxRowCount, this.reportingMF);
        resultCacheInfo.setResultKey((OlapResultStoreReferenceKey)resultKey);
        OlapResultStoreDeSerializer res = resultCache.getResult(context, (OlapResultStoreReferenceKey)resultKey);
        if (res == null) {
            return null;
        }
        OlapResultStoreInformation currentResultInfo = UxTidyExecuteMdxScriptQuery.createResultStoreInformation(context, resultCacheInfo);
        OlapResultStoreInformation cachedResultInfo = res.getInfo();
        String cachedRequestId = cachedResultInfo != null ? String.valueOf(cachedResultInfo.requestId) : "n/a";
        context.onDetailAdded("MDX (cache)", "Got result from cache [cached-request-id:" + cachedRequestId + "]");
        if (OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isInfoEnabled()) {
            OlapLoggers.MDX_EVALUATION_RESULT_CACHE.info((Object)("[result-cache] MDX " + context.getRequestId().getId() + " result from cache [cached-request-id:" + cachedRequestId + "]"));
        }
        if (cachedResultInfo != null && OlapLoggers.MDX_EVALUATION_RESULT_CACHE.isDebugEnabled()) {
            prefix = "[result-cache] MDX " + context.getRequestId().getId() + " ";
            cachedResultInfo.log(OlapLoggers.MDX_EVALUATION_RESULT_CACHE, prefix, currentResultInfo);
        }
        if (cachedResultInfo != null) {
            prefix = "[result-cache] MDX " + context.getRequestId().getId() + " ";
            cachedResultInfo.assertConsistency(OlapLoggers.MDX_EVALUATION_RESULT_CACHE, prefix, currentResultInfo);
        }
        try {
            return UxTidySerializerUtils.asMdxReplyFromCache(context_, res);
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("[reply] MDX " + String.valueOf(this.requestId) + " could not serialize the reply"), (Throwable)ex);
            return UxReply.error(context_, CdError.create((CdErrorCode)UxErrorCode.REPLY_SERIALIZATION_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
    }

    private static UxReply asReply(UxQueryContext context, String requestId, int scriptOffset, @Nullable OlapInstrExecListener listener, @Nullable OlapResultCacheInfo<RestResultStoreReferenceKey> resultCacheInfo, boolean json, boolean flat, boolean infos, OlapResScriptDataSet result) {
        OlapEngineRequestContext olapEngineRequestContext;
        OlapResultStoreInformation resultInfo;
        if (result.isError()) {
            return UxReply.actionSuccess(UxTidyExecuteMdxScriptResult.createFromError(requestId, UxTidyExecuteMdxScriptQuery.asError(context, scriptOffset, result.getError())));
        }
        if (listener instanceof OlapMdxDebugNodeCollector) {
            OlapMdxDebugNodeCollector debugger = (OlapMdxDebugNodeCollector)listener;
            UxServerRequestContext serverRequestContext = context.asServerRequestContext();
            String schemaName = result.getSchemaName();
            IcCubeServerSessionContext sessionContext = serverRequestContext.getSessionContext();
            sessionContext.setMdxDebuggerTree(schemaName, new DebugMdxQueryExecTree(requestId, scriptOffset, debugger.getRoot()));
        }
        if ((resultInfo = UxTidyExecuteMdxScriptQuery.createResultStoreInformation(olapEngineRequestContext = context.getOlapEngineRequestContext(), resultCacheInfo)) != null) {
            String prefix = "MDX " + olapEngineRequestContext.getRequestId().getId() + " ";
            resultInfo.log(OlapLoggers.MDX_EVALUATION, prefix, (Object)result);
        }
        try {
            return UxTidySerializerUtils.asMdxReply(context, resultCacheInfo, resultInfo, json, flat, infos, result.getStatementResults());
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("[reply] MDX " + requestId + " could not serialize the reply"), (Throwable)ex);
            return UxReply.error(context, CdError.create((CdErrorCode)UxErrorCode.REPLY_SERIALIZATION_ERROR, (Serializable[])new Serializable[]{ex.getMessage()}));
        }
    }

    @Nullable
    private static OlapResultStoreInformation createResultStoreInformation(OlapEngineRequestContext context, @Nullable OlapResultCacheInfo<RestResultStoreReferenceKey> resultCacheInfo) {
        if (resultCacheInfo == null || resultCacheInfo.getResultCache() == null || resultCacheInfo.getResultKey() == null) {
            return null;
        }
        OlapResultCache cache = resultCacheInfo.getResultCache();
        OlapResultCacheKey cacheKey = cache.getCacheKey();
        String locale = cacheKey.getLocale().toString();
        String roleName = cacheKey.getRoleName();
        String schemaName = cacheKey.getSchemaName();
        String schemaId = cacheKey.getSchemaId();
        Date schemaRefreshTime = cacheKey.getSchemaRefreshTime();
        String schemaPermsId = cacheKey.getSchemaPermission().getUuid();
        RestResultStoreReferenceKey resultKey = (RestResultStoreReferenceKey)resultCacheInfo.getResultKey();
        String mdxHash = resultKey.getHash();
        long requestId = context.getRequestId().getId();
        return new OlapResultStoreInformation(locale, roleName, schemaName, schemaId, schemaRefreshTime, schemaPermsId, mdxHash, requestId);
    }

    private static UxTidyExecuteMdxError asError(UxQueryContext context, int scriptOffset, ICdException exception) {
        UxJavaNativeErrors javaNativeErrors = null;
        if (exception instanceof OlapJavaNativeCompilationEvaluationException) {
            OlapJavaNativeCompilationEvaluationException jException = (OlapJavaNativeCompilationEvaluationException)exception;
            ArrayList<UxJavaNativeError> errors = new ArrayList<UxJavaNativeError>();
            for (CompilationException.Error compilationError : jException.getCompilationErrors()) {
                errors.add(new UxJavaNativeError(compilationError.getLineNumber(), compilationError.getStartPosition(), compilationError.getEndPosition(), compilationError.getErrorMessage()));
            }
            if (!errors.isEmpty()) {
                javaNativeErrors = new UxJavaNativeErrors(jException.getSourceCode(), errors);
            }
        }
        CdError error = exception.getError();
        UxMdxRange range = UxUtils.setupMdxRange(scriptOffset, error.getLocation());
        String errorCode = error.getCode().getValue();
        String errorMessage = error.asMessage((CdBabylonService)context.getOlapBabylonService());
        return new UxTidyExecuteMdxError(errorCode, errorMessage, range, javaNativeErrors);
    }
}

