/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.riskpro;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import crazydev.common.babylon.CdBabylonService;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.restapi.client.reply.RestApiClientReply;
import crazydev.iccube.restapi.client.reply.RestApiClientReplyDeserializer;
import crazydev.iccube.restapi.client.reply.schema.RestApiClientSchemaLifeCycleStatus;
import crazydev.iccube.restapi.client.reply.schema.RestApiClientSchemaLoadStatus;
import crazydev.iccube.riskpro.RPSchema;
import crazydev.iccube.server.context.IcCubeServerApplicationContext;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.queries.riskpro.UxCreateAndLoadSolveQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxRequestProcessor;
import crazydev.iccube.ux.processor.UxServerRequest;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jetbrains.annotations.Nullable;

public class UxCreateAndLoadSolveQuery
extends UxQuery {
    private final long solveId;
    private final String baseCurrency;
    private final String jdbcUrl;
    private final String rpEndPoint;
    private final String rpEndPointCS;
    private final String rpAuthToken;
    private final boolean rpAuthTokenB64;
    private final String rpAuthTokenB64CS;
    private final boolean deployToBuilder;
    @Nullable
    private final String fixManualExport;

    public UxCreateAndLoadSolveQuery(UxCreateAndLoadSolveQueryMeta meta, OlapRequestId requestId, long solveId, String baseCurrency, String jdbcUrl, String rpEndPoint, String rpEndPointCS, String rpAuthToken, boolean rpAuthTokenB64, String rpAuthTokenB64CS, boolean deployToBuilder, @Nullable String fixManualExport) {
        super(meta, requestId);
        this.solveId = solveId;
        this.baseCurrency = baseCurrency;
        this.jdbcUrl = jdbcUrl;
        this.rpEndPoint = rpEndPoint;
        this.rpEndPointCS = rpEndPointCS;
        this.rpAuthToken = rpAuthToken;
        this.rpAuthTokenB64 = rpAuthTokenB64;
        this.rpAuthTokenB64CS = rpAuthTokenB64CS;
        this.deployToBuilder = deployToBuilder;
        this.fixManualExport = fixManualExport;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)"[CreateAndLoadSolve] -------------------------------------------------------");
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]          solveId : " + this.solveId));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]     baseCurrency : " + this.baseCurrency));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]          jdbcUrl : " + UxCreateAndLoadSolveQuery.blurJdbcUrl(this.jdbcUrl)));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]       rpEndPoint : " + this.rpEndPoint));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]     rpEndPointCS : " + this.rpEndPointCS));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]      rpAuthToken : " + UxCreateAndLoadSolveQuery.blurToken(this.rpAuthToken)));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]   rpAuthTokenB64 : " + this.rpAuthTokenB64));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] rpAuthTokenB64CS : " + this.rpAuthTokenB64CS));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]  deployToBuilder : " + this.deployToBuilder));
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve]  fixManualExport : " + this.fixManualExport));
            OlapLoggers.UX_REQUEST.info((Object)"[CreateAndLoadSolve] -------------------------------------------------------");
        }
        try {
            String solveJson = this.retrieveSolveMeta();
            String schemaName = "RP_Solve_" + this.solveId;
            String schemaXml = this.generateSchema(queryContext, schemaName, solveJson);
            this.unload(queryContext, schemaName);
            this.undeploy(queryContext, schemaName);
            this.deploy(queryContext, schemaName, schemaXml);
            this.load(queryContext, schemaName);
            return UxReply.actionSuccess();
        }
        catch (Exception ex) {
            OlapLoggers.UX_REQUEST.error((Object)"CreateAndLoadSolve error", (Throwable)ex);
            return UxReply.error("CreateAndLoadSolve error (please check the logs for more details) : " + ex.getMessage());
        }
    }

    private String retrieveSolveMeta() throws IOException, URISyntaxException {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] retrieve solve meta for [" + this.solveId + "]"));
        }
        String meta = "HVaR".equals(this.fixManualExport) ? Files.readString(Path.of("/home/mpo/icCube/src/icCubeServer/ic3-main/src/test/resources/crazydev/iccube/tst/riskpro/hvarJson.json", new String[0])) : ("Solve".equals(this.fixManualExport) ? Files.readString(Path.of("/home/mpo/icCube/src/icCubeServer/ic3-main/src/test/resources/crazydev/iccube/tst/riskpro/riskpro_olap_schema_example.json", new String[0])) : this.retrieveSolveMetaEx());
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] retrieved solve meta \n" + meta));
        }
        return meta;
    }

    private String retrieveSolveMetaEx() throws IOException, URISyntaxException {
        URI uri = new URI(String.format("%s/%d/meta-data", this.rpEndPoint, this.solveId));
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] retrieve solve meta @ [" + String.valueOf(uri) + "]"));
        }
        HttpGet post = new HttpGet(uri);
        String bearer = this.rpAuthTokenB64 ? Base64.getEncoder().encodeToString(this.rpAuthToken.getBytes(this.rpAuthTokenB64CS)) : this.rpAuthToken;
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] header Authorization : Bearer " + UxCreateAndLoadSolveQuery.blurToken(bearer)));
        }
        post.setHeader("Authorization", "Bearer " + bearer);
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] header Accept : application/json;charset=" + this.rpEndPointCS));
        }
        post.setHeader("Accept", "application/json;charset=" + this.rpEndPointCS);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            String string;
            block16: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
                try {
                    StatusLine statusLine = response.getStatusLine();
                    if (statusLine.getStatusCode() >= 300) {
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    ByteArrayOutputStream content = new ByteArrayOutputStream();
                    HttpEntity entity = response.getEntity();
                    InputStream in = entity.getContent();
                    IOUtils.copy((InputStream)in, (OutputStream)content);
                    string = content.toString(this.rpEndPointCS);
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    private String generateSchema(UxQueryContext context, String schemaName, String solveJson) throws Exception {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] generate icCube schema [" + schemaName + "]"));
        }
        Gson gson = new GsonBuilder().create();
        RPSchema data = (RPSchema)gson.fromJson((Reader)new StringReader(solveJson), RPSchema.class);
        data.fixManualExport(this.fixManualExport);
        OlapEngineComponent engine = context.getOlapEngineComponent();
        Class[] meta = engine.getBuilderMetaInformationRepository().getPersistentClasses();
        UxBabylonService babylon = context.getUxBabylonService();
        String xml = data.toXml((CdBabylonService)babylon, meta, schemaName, "RiskPro", this.baseCurrency, this.jdbcUrl, this.solveId);
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] generate icCube schema [" + schemaName + "] completed"));
        }
        return xml;
    }

    private void unload(UxQueryContext queryContext, String schemaName) throws IOException {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] unload icCube schema [" + schemaName + "]"));
        }
        String url = "/console/admin/UnloadSchema";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("schemaName", schemaName);
        Gson gson = new GsonBuilder().create();
        String args = gson.toJson(params);
        RestApiClientReply<RestApiClientSchemaLifeCycleStatus> response = this.dispatch(queryContext, RestApiClientSchemaLifeCycleStatus.class, "/console/admin/UnloadSchema", args);
        if (response.isOK()) {
            RestApiClientSchemaLifeCycleStatus payload = response.getPayload();
            if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
                OlapLoggers.UX_REQUEST.info((Object)String.format("[CreateAndLoadSolve] unload icCube schema [%s] completed : %s %s", new Object[]{schemaName, payload.status, CdStringUtils.isNotNullAndNotBlank((String)payload.info) ? payload.info : ""}));
            }
        } else {
            OlapLoggers.UX_REQUEST.error((Object)String.format("[CreateAndLoadSolve] unload icCube schema [%s] completed on error: %s", schemaName, response.getAsError()));
            throw new RuntimeException("unexpected unload schema error (please check the logs)");
        }
    }

    private void undeploy(UxQueryContext queryContext, String schemaName) {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] undeploy icCube schema [" + schemaName + "]"));
        }
        File schemaFactoryFile = this.createSchemaFactoryFile(queryContext, schemaName);
        OlapEngineSchemaDefFactoryHelper helper = queryContext.getDeployedSchemaDefFactoryHelper();
        boolean deleted = helper.deleteSchemaDefFactoryFile(schemaFactoryFile);
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] undeploy icCube schema [" + schemaName + "] completed : " + deleted));
        }
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] undeploy (builder) icCube [schema " + schemaName + "]"));
        }
        UxSchemaId schemaId = new UxSchemaId(schemaName, schemaName + ".icc-schema");
        UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
        service.deleteSchema(schemaId);
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] undeploy (builder) icCube [schema " + schemaName + "] completed"));
        }
    }

    private void deploy(UxQueryContext queryContext, String schemaName, final String schemaXml) throws IOException {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] deploy icCube schema [" + schemaName + "]"));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(schemaXml.getBytes(StandardCharsets.UTF_8));
        File schemaFactoryFile = this.createSchemaFactoryFile(queryContext, schemaName);
        String savedBy = queryContext.getUserName();
        String operation = "deployed";
        OlapEngineSchemaDefFactoryHelper helper = queryContext.getDeployedSchemaDefFactoryHelper();
        helper.writeSchemaDefFactoryFileContent(savedBy, schemaFactoryFile, (InputStream)in, "deployed");
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] deploy icCube schema [" + schemaName + "] completed"));
        }
        if (this.deployToBuilder) {
            if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
                OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] deploy (builder) icCube schema [" + schemaName + "]"));
            }
            UxServerRequestParams params = new UxServerRequestParams(this, null){
                {
                    Objects.requireNonNull(this$0);
                    super(httpRequest);
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(schemaXml.getBytes(StandardCharsets.UTF_8));
                }
            };
            UxBuilderSchemaService service = queryContext.getPersistentSchemaService();
            service.saveSchemaDefForUpload(savedBy, schemaName + ".icc-schema", params);
            if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
                OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] deploy (builder) icCube schema [" + schemaName + "] completed"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void load(UxQueryContext queryContext, String schemaName) throws IOException {
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] load icCube schema [" + schemaName + "]"));
        }
        String url = "/console/admin/LoadSchema";
        HashMap<String, CallSite> params = new HashMap<String, CallSite>();
        params.put("schemaFile", (CallSite)((Object)(schemaName + ".icc-schema")));
        Gson gson = new GsonBuilder().create();
        String args = gson.toJson(params);
        RestApiClientReply<RestApiClientSchemaLifeCycleStatus> response = this.dispatch(queryContext, RestApiClientSchemaLifeCycleStatus.class, "/console/admin/LoadSchema", args);
        if (!response.isOK()) {
            OlapLoggers.UX_REQUEST.error((Object)String.format("[CreateAndLoadSolve] load icCube schema [%s] completed on error: %s", schemaName, response.getAsError()));
            throw new RuntimeException("unexpected load schema error (please check the icCube logs)");
        }
        RestApiClientSchemaLifeCycleStatus payload = response.getPayload();
        if (payload.status == RestApiClientSchemaLoadStatus.LOADED) {
            if (!OlapLoggers.UX_REQUEST.isInfoEnabled()) return;
            OlapLoggers.UX_REQUEST.info((Object)String.format("[CreateAndLoadSolve] load icCube schema [%s] completed : %s %s", new Object[]{schemaName, payload.status, CdStringUtils.isNotNullAndNotBlank((String)payload.info) ? payload.info : ""}));
            return;
        }
        OlapLoggers.UX_REQUEST.error((Object)String.format("[CreateAndLoadSolve] load icCube schema [%s] completed w/ unexpected status : %s %s", new Object[]{schemaName, payload.status, CdStringUtils.isNotNullAndNotBlank((String)payload.info) ? payload.info : ""}));
        throw new RuntimeException("unexpected load schema status (please check the icCube logs)");
    }

    private File createSchemaFactoryFile(UxQueryContext context, String schemaName) {
        File schemaFile = new File(schemaName + ".icc-schema");
        File schemaFactoryFile = context.createSchemaFactoryFile(false, schemaFile).__getUnderlying();
        if (OlapLoggers.UX_REQUEST.isInfoEnabled()) {
            OlapLoggers.UX_REQUEST.info((Object)("[CreateAndLoadSolve] factory file for icCube schema : " + schemaFactoryFile.getAbsolutePath()));
        }
        return schemaFactoryFile;
    }

    private <T> RestApiClientReply<T> dispatch(UxQueryContext queryContext, Class<T> clazz, String url, String args) throws IOException {
        Map<String, String[]> restApiParameterMap = Collections.emptyMap();
        String restApiPathInfo = url;
        IcCubeServerApplicationContext appContext = queryContext.getApplicationContext();
        UxRequestProcessor processor = appContext.getUxRequestProcessor();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)new HttpServletRequestHandler(queryContext, "POST", restApiPathInfo, restApiParameterMap, args));
        HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)new HttpServletResponseHandler(queryContext, out));
        OlapRequestType requestType = OlapRequestType.UX_API;
        OlapRequestId requestId = OlapRequestId.next((OlapRequestType)requestType);
        OlapRequestId.setThreadRequestId((OlapRequestId)requestId);
        processor.processUxRequest(UxApi.REST, request, response);
        String payload = out.toString(StandardCharsets.UTF_8);
        Gson gson = new GsonBuilder().registerTypeAdapter(RestApiClientReply.class, (Object)new RestApiClientReplyDeserializer(clazz)).create();
        RestApiClientReply reply = (RestApiClientReply)gson.fromJson(payload, RestApiClientReply.class);
        return reply;
    }

    private static String blurJdbcUrl(String url) {
        if (CdStringUtils.isNullOrBlank((String)url)) {
            return url;
        }
        return url.replaceAll("password=.*", "...");
    }

    private static String blurToken(String token) {
        if (CdStringUtils.isNullOrBlank((String)token)) {
            return token;
        }
        return token.substring(0, Math.min(8, token.length() / 2)) + "...";
    }

    static class HttpServletRequestHandler
    implements InvocationHandler {
        private final HttpServletRequest tunnellingRequest;
        private final Map<String, String[]> restApiParameterMap;
        private final String restApiMethod;
        private final String restApiPathInfo;
        private final String restApiArgs;

        public HttpServletRequestHandler(UxQueryContext context, String method, String pathInfo, Map<String, String[]> parameterMap, @Nullable String args) {
            UxServerRequestContext serverContext = context.asServerRequestContext();
            UxServerRequest request = (UxServerRequest)((Object)serverContext.getRequest());
            this.tunnellingRequest = request.getHttpRequest();
            this.restApiParameterMap = parameterMap;
            this.restApiMethod = method;
            this.restApiPathInfo = pathInfo;
            this.restApiArgs = args;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("setCharacterEncoding")) {
                return null;
            }
            if (method.getName().equals("getParameterMap")) {
                return this.restApiParameterMap;
            }
            if (method.getName().equals("getMethod")) {
                return this.restApiMethod;
            }
            if (method.getName().equals("getContentType")) {
                return "application/json";
            }
            if (method.getName().equals("getReader")) {
                return new BufferedReader(new StringReader(this.restApiArgs != null ? this.restApiArgs : ""));
            }
            if (method.getName().equals("getSession")) {
                return this.tunnellingRequest.getSession(false);
            }
            if (method.getName().equals("getPathInfo")) {
                return this.restApiPathInfo;
            }
            if (method.getName().equals("getCookies")) {
                return this.tunnellingRequest.getCookies();
            }
            if (method.getName().equals("getHeader")) {
                String header = (String)args[0];
                if ("X-CONSOLE".equals(header)) {
                    return "ic3";
                }
                return this.tunnellingRequest.getHeader(header);
            }
            if (method.getName().equals("toString")) {
                return this.restApiPathInfo;
            }
            throw new RuntimeException("internal error: HttpServletRequest." + method.getName() + " not supported");
        }
    }

    static class HttpServletResponseHandler
    implements InvocationHandler {
        private final UxQueryContext context;
        private final ByteArrayOutputStream out;
        private final ServletOutputStream sOut;

        public HttpServletResponseHandler(UxQueryContext context, final ByteArrayOutputStream out) {
            this.context = context;
            this.out = out;
            this.sOut = new ServletOutputStream(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public boolean isReady() {
                    return false;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) throws IOException {
                    out.write(b);
                }
            };
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return switch (method.getName()) {
                case "setContentType" -> null;
                case "getOutputStream" -> this.sOut;
                case "toString" -> this.out.toString(StandardCharsets.UTF_8);
                default -> throw new RuntimeException("internal error: HttpServletResponse." + method.getName() + " not supported");
            };
        }
    }
}

