/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.debug;

import crazydev.common.utils.CdArrayUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.gwt.server.requesthandler.debugger.LazyTreeDebuggerCommand;
import crazydev.iccube.gwt.shared.portlets.debugger.command.GwtDebugMdxQueryExecTreeNodeQuery;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeModel;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeNodeModel;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.builder.common.UxLazyTreeStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.debug.result.UxMdxDebugBrowsingNode;
import crazydev.iccube.ux.mdx.queries.debug.result.UxMdxDebugBrowsingTree;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBrowseMdxDebugQuery
extends UxMdxConsoleQuery {
    private final String mdxRequestId;
    private final String schemaName;
    @Nullable
    private final String treeId;
    @Nullable
    private final List<Integer> nodeId;

    protected UxBrowseMdxDebugQuery(UxQueryMeta meta, OlapRequestId requestId, String mdxRequestId, String schemaName, @Nullable String treeId, @Nullable List<Integer> nodeId) {
        super(meta, requestId);
        this.mdxRequestId = mdxRequestId;
        this.schemaName = schemaName;
        this.treeId = treeId;
        this.nodeId = nodeId;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        IcCubeServerSessionContext serverSessionContext = serverRequestContext.getSessionContext();
        DebugMdxQueryExecTree debugTree = serverSessionContext.getMdxDebuggerTree(this.schemaName);
        if (debugTree == null || !debugTree.getQueryId().equals(this.mdxRequestId)) {
            return UxReply.actionSuccess(new UxMdxDebugBrowsingTree());
        }
        GwtLazyTreePathTreeNodeIdentifier parentNodeId = this.nodeId != null && !this.nodeId.isEmpty() ? new GwtLazyTreePathTreeNodeIdentifier("", CdArrayUtils.toIntArray(this.nodeId)) : null;
        GwtDebugMdxQueryExecTreeNodeQuery serverQuery = new GwtDebugMdxQueryExecTreeNodeQuery(this.schemaName, this.treeId, "n/a", parentNodeId, this.mdxRequestId);
        OlapBabylonService babylon = serverRequestContext.getBabylonService();
        int maxChildrenCount = serverRequestContext.getServerProperties().getMaxChildrenCountForMdxDebugger();
        LazyTreeDebuggerCommand cmd = new LazyTreeDebuggerCommand(serverRequestContext, babylon, maxChildrenCount, serverQuery, debugTree, true);
        DebugMdxQueryExecTreeModel tree = (DebugMdxQueryExecTreeModel)cmd.call();
        return UxReply.actionSuccess(new UxMdxDebugBrowsingTree(tree.isOutOfSync() ? UxLazyTreeStatus.OUT_OF_SYNC : null, tree.getServerTreeUId(), this.nodeId, this.asNodes(tree.getNodeModels())));
    }

    @Nullable
    private List<UxMdxDebugBrowsingNode> asNodes(@Nullable List<DebugMdxQueryExecTreeNodeModel> models) {
        if (models == null || models.isEmpty()) {
            return null;
        }
        ArrayList<UxMdxDebugBrowsingNode> nodes = new ArrayList<UxMdxDebugBrowsingNode>();
        for (DebugMdxQueryExecTreeNodeModel model : models) {
            String caption = model.getTitle();
            boolean isMoreItem = model.isMoreElement();
            GwtLazyTreePathTreeNodeIdentifier nodeId = model.getNodeId();
            ArrayList<Integer> id = new ArrayList<Integer>();
            if (nodeId != null) {
                int[] positions;
                for (int position : positions = nodeId.getPathPositions()) {
                    id.add(position);
                }
            }
            List<DebugMdxQueryExecTreeNodeModel> children = model.getChildren();
            nodes.add(new UxMdxDebugBrowsingNode(id, caption, this.asNodes(children), isMoreItem));
        }
        return nodes;
    }
}

