/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.gvi;

import crazydev.common.utils.CdLocaleUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.server.gvi.request.report.GviGetReportingMetaInfoQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.gvi.UxReportingLocaleInfo;
import crazydev.iccube.ux.gvi.UxReportingLocaleInfos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxReportingLocalesQuery
extends UxQuery {
    @Nullable
    private final Locale locale;

    protected UxReportingLocalesQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String locale) {
        super(meta, requestId);
        this.locale = locale != null ? CdLocaleUtils.fromName((String)locale) : null;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        Locale[] locales = Locale.getAvailableLocales();
        OlapEngineRequestContext requestContext = queryContext.getOlapEngineRequestContext();
        OlapBabylonService babylonService = requestContext.getBabylonService();
        ArrayList<UxReportingLocaleInfo> infos = new ArrayList<UxReportingLocaleInfo>();
        Locale inLocale = this.locale != null ? this.locale : babylonService.getLocale();
        for (Locale locale : locales) {
            String localeInternalName = locale.toString();
            if (CdStringUtils.isNullOrBlank((String)localeInternalName)) continue;
            String caption = locale.getDisplayName(inLocale);
            GviGetReportingMetaInfoQuery.Separators separators = GviGetReportingMetaInfoQuery.Separators.getSeparators(requestContext, locale);
            infos.add(new UxReportingLocaleInfo(localeInternalName, caption, separators.decimalSeparator, separators.thousandSeparator));
        }
        infos.sort(Comparator.comparing(o -> o.c));
        return UxReply.actionSuccess(new UxReportingLocaleInfos(infos));
    }
}

