/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.gvi;

import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.reportquery.OlapReportDataSourceMeta;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.gvi.UxReportingJdbcDataSourceNames;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxReportingJdbcDataSourceNamesQuery
extends UxQuery {
    private final String schema;

    protected UxReportingJdbcDataSourceNamesQuery(UxQueryMeta meta, OlapRequestId requestId, String schema) {
        super(meta, requestId);
        this.schema = schema;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
            OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
            List dataSources = olapEngine.getAuthorizedDataSources(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schema);
            if (dataSources != null) {
                for (OlapBuilderBaseDataSource dataSource : dataSources) {
                    OlapReportDataSourceMeta meta = dataSource.getReportDataSourceMeta();
                    if (!meta.getType().equals("jdbc")) continue;
                    names.add(dataSource.getName());
                }
            }
        }
        catch (OlapMissingSchemaException olapMissingSchemaException) {
            // empty catch block
        }
        return UxReply.actionSuccess(new UxReportingJdbcDataSourceNames(names));
    }
}

