/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.gvi;

import crazydev.iccube.olap.component.OlapMissingSchemaException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.gvi.request.common.GviSchemaOlapEngineQuery;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.gvi.UxReportingCubeName;
import crazydev.iccube.ux.gvi.UxReportingCubeNames;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxReportingCubeNamesQuery
extends UxQuery {
    private final String schema;

    protected UxReportingCubeNamesQuery(UxQueryMeta meta, OlapRequestId requestId, String schema) {
        super(meta, requestId);
        this.schema = schema;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        ArrayList<UxReportingCubeName> names = new ArrayList<UxReportingCubeName>();
        try {
            List<OlapCube> cubes = GviSchemaOlapEngineQuery.getLoadedCubes(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schema);
            if (cubes != null) {
                OlapRequestNamesContext nameContext = engineRequestContext.getNameContext();
                for (OlapCube cube : cubes) {
                    String caption = cube.getCaption(engineRequestContext.getLocale(), (OlapNameContext)nameContext);
                    String name = cube.getName((OlapNameContext)nameContext);
                    names.add(new UxReportingCubeName(name, caption));
                }
            }
        }
        catch (OlapMissingSchemaException olapMissingSchemaException) {
            // empty catch block
        }
        return UxReply.actionSuccess(new UxReportingCubeNames(names));
    }
}

