/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.upload;

import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.dashboards.UxDashboardsInstallVersionQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsRepositoryType;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingHelper;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.UxConsoleQueryMeta;
import crazydev.iccube.ux.console.queries.upload.UxFileType;
import crazydev.iccube.ux.console.queries.upload.UxUploadFileQuery;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxUploadFileQueryMeta
extends UxConsoleQueryMeta {
    public static final String USER_UUID = "userUUID";
    public static final String FILE_TYPE = "fileType";
    public static final String FILE_EXT = "fileExt";
    public static final String REPOSITORY = "repository";
    public static final String PATH = "path";
    public static final String OVERWRITE = "overwrite";
    public static final String EXPAND_ZIP = "expandZIP";
    public static final String BACKUP = "backup";
    public static final UxUploadFileQueryMeta UploadFile = new UxUploadFileQueryMeta();

    public UxUploadFileQueryMeta() {
        super(UxConsoleConstants.QueryName.UploadFile);
    }

    @Override
    public boolean isFileUpload() {
        return true;
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return super.isAuthorized(context);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        UxFileType fileType = params.getEnumParameter(UxFileType.class, FILE_TYPE);
        String xFile = params.getHeader("X-File-Name");
        if (xFile != null) {
            String fileName = params.getStringParameter("qqfile");
            return new UxUploadFileQuery(this, params, fileType, fileName);
        }
        throw new RuntimeException("internal error: unexpected UploadFile query : FORM");
    }

    @Nullable
    public static UxAction createActionForSchema(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadDeployedSchema", new Serializable[0])).withPlacement(1).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.SCHEMA_DEF_DEPLOYED.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("icc-schema"))).build();
    }

    @Nullable
    public static UxAction createActionForBackup(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translateActionCaption("UploadBackup", new Serializable[0]);
        String captionSearch = babylon.translateActionCaptionSearch("UploadBackup", new Serializable[0]);
        return new UxActionBuilder(context, UploadFile).withCaption(caption).withCaptionSearch(captionSearch).withPlacement(1).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.SCHEMA_BACKUP.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("zip"))).build();
    }

    @Nullable
    public static UxAction createActionForOffline(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadOffline", new Serializable[0])).withPlacement(1).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.SCHEMA_OFFLINE.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("zip"))).build();
    }

    @Nullable
    public static UxAction createActionForAlerts(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadAlerts", new Serializable[0])).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.ALERTS_SCHEDULE.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(IcCubeSchedulerKind.fileExtension()))).build();
    }

    @Nullable
    public static UxAction createActionForSchemaSchedules(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadSchemasSchedule", new Serializable[0])).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.SCHEMAS_SCHEDULE.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(IcCubeSchedulerKind.fileExtension()))).build();
    }

    @Nullable
    public static UxAction createActionForUsers(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadUsers", new Serializable[0])).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.USERS.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("icc-users"))).build();
    }

    @Nullable
    public static UxAction createActionForUserProfilePhoto(UxQueryContext context, @Nullable String uuid) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadUserProfilePhoto", new Serializable[0])).withParams(new UxField(babylon, USER_UUID, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(uuid)), new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.USER_PROFILE_PHOTO.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("png"))).build();
    }

    @Nullable
    public static UxAction createActionForRoles(UxQueryContext context) {
        if (!context.canEditOwnsRole(null)) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadRoles", new Serializable[0])).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.ROLES.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("icc-roles"))).build();
    }

    @Nullable
    public static UxAction createActionForDocs(UxQueryContext context, int placement, UxDocsRepositoryType repositoryType, OlapPath path) {
        UxBabylonService babylon = context.getUxBabylonService();
        String synopsis = babylon.translate("uploadTo", new Serializable[]{!path.isEmpty() ? path.toSimplePath() : "/"});
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadFiles", new Serializable[0])).withPlacement(placement).withSynopsis(synopsis).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.DOCS.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue()), new UxField(babylon, REPOSITORY, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(repositoryType.name())), new UxField(babylon, PATH, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(path.toSimplePath())), new UxField(babylon, OVERWRITE, new UxFieldMeta(UxFieldTypes.BOOLEAN, false, false, false), new UxFieldValue(true)), new UxField(babylon, EXPAND_ZIP, new UxFieldMeta(UxFieldTypes.BOOLEAN, true, false, false), new UxFieldValue(true))).build();
    }

    @Nullable
    public static UxAction createActionForDashboardsInstall(UxQueryContext context) {
        if (!UxReportingHelper.isReportingInDocs(context) || !UxDashboardsInstallVersionQueryMeta.DashboardsInstallVersion.isAuthorized(context)) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String caption = babylon.translate("backup.dashboard", new Serializable[0]);
        UxHelpText description = babylon.translateWizardDescription("backup.dashboard");
        return new UxActionBuilder(context, UploadFile).withId("DashboardsInstall").withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.DASHBOARDS.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("zip")), new UxField(BACKUP, caption, description, new UxFieldMeta(UxFieldTypes.BOOLEAN, false, true, false), new UxFieldValue(true))).withPlacement(1).build();
    }

    @Nullable
    public static UxAction createActionForSchemaDef(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        return new UxActionBuilder(context, UploadFile).withCaption(babylon.translateActionCaption("UploadSchemaDef", new Serializable[0])).withPlacement(1).withParams(new UxField(babylon, FILE_TYPE, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue(UxFileType.SCHEMA_DEF.name())), new UxField(babylon, FILE_EXT, new UxFieldMeta(UxFieldTypes.STRING, false, true, true), new UxFieldValue("icc-schema"))).build();
    }
}

