/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.tenant;

import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.ux.UxActionContinuationKind;
import crazydev.iccube.ux.admin.queries.completion.UxCompleteQueryMeta;
import crazydev.iccube.ux.admin.queries.completion.UxCompletionType;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.common.field.UxFieldTypes;
import crazydev.iccube.ux.common.field.UxFieldValue;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.UxConsoleQueryMeta;
import crazydev.iccube.ux.console.queries.tenant.UxSetTenantQuery;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import org.jetbrains.annotations.Nullable;

public class UxSetTenantQueryMeta
extends UxConsoleQueryMeta {
    public static final UxSetTenantQueryMeta SetTenant = new UxSetTenantQueryMeta();

    private UxSetTenantQueryMeta() {
        super(UxConsoleConstants.QueryName.SetTenant);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return context.isWithMultiTenant() && context.isSuperAdministrator();
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) {
        String tenant = params.getStringParameter("tenant");
        return new UxSetTenantQuery(this, params.getRequestId(), tenant);
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context) {
        UxBabylonService babylon = context.getUxBabylonService();
        OlapTenant tenant = context.getUserTenant();
        return new UxActionBuilder(context, SetTenant).withContinuation(UxActionContinuationKind.RELOAD).withParams(new UxField(babylon, "tenant", new UxFieldMeta(UxFieldTypes.STRING, UxCompleteQueryMeta.createAction(context, UxCompletionType.tenant, new String[0]), true, true, false, false), new UxFieldValue(tenant != null ? tenant.getName() : null))).build();
    }
}

