/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.search;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseRepository;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.repository.UxSearchMatch;
import crazydev.iccube.ux.console.UxConsoleQuery;
import crazydev.iccube.ux.console.queries.init.UxConsoleInitDataQuery;
import crazydev.iccube.ux.console.queries.search.UxSearchScope;
import crazydev.iccube.ux.console.queries.search.UxSearchSuggestion;
import crazydev.iccube.ux.console.queries.search.UxSearchSuggestionGroup;
import crazydev.iccube.ux.console.queries.search.UxSearchSuggestionKind;
import crazydev.iccube.ux.console.queries.search.UxSearchSuggestions;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxSearchSuggestionsQuery
extends UxConsoleQuery {
    @Nullable
    private final String searchText;
    @Nullable
    private final UxSearchScope searchScope;

    protected UxSearchSuggestionsQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable String searchText, @Nullable UxSearchScope searchScope) {
        super(meta, requestId);
        this.searchText = searchText;
        this.searchScope = searchScope;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        ArrayList<UxSearchSuggestionGroup> groups = new ArrayList<UxSearchSuggestionGroup>();
        if (this.searchScope != null && CdStringUtils.isNotNullAndNotBlank((String)this.searchText)) {
            UxSearchSuggestionsQuery.search(queryContext, groups, this.searchScope, this.searchText);
        }
        return UxReply.actionSuccess(new UxSearchSuggestions(groups));
    }

    private static void search(UxQueryContext context, List<UxSearchSuggestionGroup> groups, UxSearchScope searchScope, String input) {
        switch (searchScope) {
            case admin: {
                UxSearchSuggestionsQuery.searchAdmin(context, groups, input);
                break;
            }
            case mdx: {
                UxSearchSuggestionsQuery.searchMdx(context, groups, input);
                break;
            }
            case builder: {
                UxSearchSuggestionsQuery.searchBuilder(context, groups, input);
                break;
            }
            case console: {
                UxSearchSuggestionsQuery.searchConsole(context, groups, input);
            }
        }
    }

    private static void searchAdmin(UxQueryContext context, List<UxSearchSuggestionGroup> groups, String input) {
        List<UxUseCase> useCases;
        UxUseCase useCase;
        UxAdminUseCaseRepository repository = context.getOrCreateAdminUseCaseRepository();
        List<UxSearchMatch> matches = repository.search(input);
        ArrayList<UxSearchSuggestion> suggestions = new ArrayList<UxSearchSuggestion>();
        for (UxSearchMatch match : matches) {
            useCase = match.useCase();
            if (match.action() != null) continue;
            UxAction actionUC = new UxActionBuilder(context, useCase.meta()).withUseCase(useCase).build();
            suggestions.add(new UxSearchSuggestion(UxSearchSuggestionKind.USE_CASE, useCase.id(), null, useCase.captionForSearchSuggestion(), actionUC));
            if (suggestions.size() < 10) continue;
            break;
        }
        if (!suggestions.isEmpty()) {
            useCases = UxConsoleInitDataQuery.setupUseCases(context, UxAppType.admin, null);
            groups.add(new UxSearchSuggestionGroup("admin-use-cases", suggestions, useCases));
        }
        suggestions = new ArrayList();
        for (UxSearchMatch match : matches) {
            useCase = match.useCase();
            UxAction action = match.action();
            if (action == null) continue;
            UxAction actionUC = new UxActionBuilder(context, useCase.meta()).withUseCase(useCase).build();
            suggestions.add(new UxSearchSuggestion(UxSearchSuggestionKind.ACTION, action.id(), null, action.captionSearch(), actionUC));
            if (suggestions.size() < 10) continue;
            break;
        }
        if (!suggestions.isEmpty()) {
            useCases = UxConsoleInitDataQuery.setupUseCases(context, UxAppType.admin, null);
            groups.add(new UxSearchSuggestionGroup("admin-actions", suggestions, useCases));
        }
    }

    private static void searchMdx(UxQueryContext context, List<UxSearchSuggestionGroup> groups, String input) {
    }

    private static void searchBuilder(UxQueryContext context, List<UxSearchSuggestionGroup> groups, String input) {
    }

    private static void searchConsole(UxQueryContext context, List<UxSearchSuggestionGroup> groups, String input) {
        UxSearchSuggestionsQuery.searchAdmin(context, groups, input);
    }
}

