/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.profile;

import crazydev.iccube.ux.admin.queries.utils.UxArrays;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionBuilder;
import crazydev.iccube.ux.common.field.UxField;
import crazydev.iccube.ux.common.file.UxFileUploadCardinality;
import crazydev.iccube.ux.common.file.UxFileUploadMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.url.UxUrlConstants;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.console.UxConsoleConstants;
import crazydev.iccube.ux.console.UxConsoleQueryMeta;
import crazydev.iccube.ux.console.queries.profile.UxDeleteUserProfilePhotoQueryMeta;
import crazydev.iccube.ux.console.queries.profile.UxUserProfileQuery;
import crazydev.iccube.ux.console.queries.upload.UxFileType;
import crazydev.iccube.ux.console.queries.upload.UxUploadFileQueryMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxUserProfileQueryMeta
extends UxConsoleQueryMeta {
    public static final UxUserProfileQueryMeta UserProfile = new UxUserProfileQueryMeta();

    protected UxUserProfileQueryMeta() {
        super(UxConsoleConstants.QueryName.UserProfile);
    }

    @Override
    public boolean isAuthorized(UxQueryContext context) {
        return true;
    }

    @Override
    public UxUrl createQueryUrl() {
        return UxUrlConstants.API_URL_ADMIN.addPart(this.queryName.name());
    }

    @Override
    public List<UxAction> createActions(UxQueryContext context) {
        List<UxAction> actions = UxArrays.asList(new UxAction[0]);
        if (context.isAuthServiceEditable()) {
            actions.add(UxUploadFileQueryMeta.createActionForUserProfilePhoto(context, null));
            actions.add(UxDeleteUserProfilePhotoQueryMeta.createAction(context));
        }
        return actions;
    }

    @Override
    @Nullable
    public UxFileUploadMeta createFileUpload(UxQueryContext context) {
        if (!this.isAuthorized(context) || !UxUploadFileQueryMeta.UploadFile.isAuthorized(context)) {
            return null;
        }
        UxBabylonService babylon = context.getUxBabylonService();
        String okCancel = babylon.translate("action.caption.UploadFile.SCHEMAS_SCHEDULE.okCancel", new Serializable[0]);
        return new UxFileUploadMeta(UxFileUploadCardinality.SINGLE, UxFileType.USER_PROFILE_PHOTO, "png", okCancel, new UxField[0]);
    }

    @Override
    public UxQuery parseQuery(UxServerRequestParams params) throws UxQueryParserException {
        return new UxUserProfileQuery(this, params.getRequestId());
    }

    @Nullable
    public static UxAction createAction(UxQueryContext context) {
        if (!context.isAuthServiceEditable() || context.isAnonymous()) {
            return null;
        }
        UxUseCase useCase = UxUserProfileQueryMeta.createUseCase(context);
        return new UxActionBuilder(context, UserProfile).withUseCase(useCase).build();
    }

    public static UxUseCase createUseCase(UxQueryContext context) {
        return new UxUseCaseBuilder(context, UserProfile).withId(UxAdminUseCaseName.UserProfile).build(true);
    }
}

