/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.profile;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.ux.admin.queries.users.UxUsersHelper;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.console.UxConsoleQuery;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxSaveUserProfileQuery
extends UxConsoleQuery {
    @Nullable
    private final UxModel model;

    public UxSaveUserProfileQuery(UxQueryMeta meta, OlapRequestId requestId, @Nullable UxModel model) {
        super(meta, requestId);
        this.model = model;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        String userName;
        if (!queryContext.isAuthServiceEditable()) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USERS_READ_ONLY, (Serializable[])new Serializable[0]));
        }
        if (this.model == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_MISSING_DEFINITION, (Serializable[])new Serializable[0]));
        }
        boolean requiredPassword = queryContext.isUserDefinitionWithPassword();
        if (!requiredPassword) {
            queryContext.setModelTypeSetupInfo("NOT_REQUIRED_PASSWORD"::equals);
        }
        OlapUserDefinition serverModel = (OlapUserDefinition)queryContext.convertToServerModel(this.model);
        IOlapAuthenticationService service = queryContext.getAuthenticationService();
        OlapUserDefinition user = service.getUserDefinitionByName(userName = queryContext.getUserName());
        if (user == null) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_PROFILE_MISSING, (Serializable[])new Serializable[0]));
        }
        String userUUID = user.getUUID();
        String serverModelUUID = serverModel.getUUID();
        if (userUUID == null || !userUUID.equals(serverModelUUID)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_PROFILE_UUID_MISMATCH, (Serializable[])new Serializable[0]));
        }
        String serverModelName = serverModel.getName();
        if (service.isUserNameCaseSensitive() ? !userName.equals(serverModelName) : !userName.equalsIgnoreCase(serverModelName)) {
            return UxReply.error(queryContext, CdError.create((CdErrorCode)UxErrorCode.USER_PROFILE_NAME_MISMATCH, (Serializable[])new Serializable[0]));
        }
        serverModel.setRoles(user.getRoles());
        int revNumber = this.model.getRevNumber();
        UxValidationResult error = UxUsersHelper.saveUserDefinition(queryContext, serverModel, revNumber);
        if (error != null) {
            return UxReply.validationErrors(error);
        }
        return UxReply.actionSuccess();
    }
}

