/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.utils;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.javacompiler.CompilationException;
import crazydev.common.mdx.scanner.CdMdxTokenLocationRange;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.builder.errors.OlapBuilderJavaCompilationError;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyLevelDef;
import crazydev.iccube.builder.model.def.IOlapBuilderLocalizationDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPerspectiveDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderScriptDef;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.contextual.OlapContextualErrorLocation;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.gwt.base.shared.model.mdx.GwtMdxQueryRange;
import crazydev.iccube.gwt.base.shared.model.mdx.GwtMdxQueryRangeRegion;
import crazydev.iccube.mdx.parser.exception.MdxParserTokenLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRanges;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderTablePathName;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQueryMeta;
import crazydev.iccube.ux.builder.queries.datasource.UxDataSourceQueryMeta;
import crazydev.iccube.ux.builder.queries.datatable.UxDataTableQueryMeta;
import crazydev.iccube.ux.builder.queries.dataview.UxDataViewQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.perspective.UxPerspectiveQueryMeta;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.validation.UxJavaNativeError;
import crazydev.iccube.ux.common.validation.UxJavaNativeErrors;
import crazydev.iccube.ux.common.validation.UxMdxRange;
import crazydev.iccube.ux.common.validation.UxMdxRangeRegion;
import crazydev.iccube.ux.common.validation.UxValidationMessage;
import crazydev.iccube.ux.common.validation.UxValidationMessageRef;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public abstract class UxUtils {
    private UxUtils() {
    }

    public static String formatTimeServer(UxBabylonService babylon, @Nullable Date timestamp) {
        if (timestamp == null) {
            return "-";
        }
        try {
            Locale locale = babylon.getLocale();
            SimpleDateFormat df = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", locale);
            return df.format(timestamp);
        }
        catch (RuntimeException ex) {
            return timestamp.toString();
        }
    }

    public static String formatNextTimeServer(UxBabylonService babylon, @Nullable Date timestamp) {
        if (timestamp == null) {
            return "-";
        }
        long timestampMS = timestamp.getTime();
        long delayMS = timestampMS - System.currentTimeMillis();
        String time = UxUtils.formatTimeServer(babylon, timestamp);
        String now = UxUtils.formatTimeServer(babylon, new Date());
        String delay = CdTimeUtils.formatMillis((Locale)babylon.getLocale(), (long)delayMS);
        String info = babylon.translate("nextTime", new Serializable[]{time, now, delay});
        return info;
    }

    public static UxValidationResult setupValidationResult(UxQueryContext context, OlapBabylonService babylon, CdError errors) {
        return UxUtils.setupValidationResult(context, babylon, Collections.singletonList(errors));
    }

    public static UxValidationResult setupValidationResult(UxQueryContext context, OlapBabylonService babylon, List<? extends CdError> errors) {
        ArrayList<UxValidationMessage> messages = new ArrayList<UxValidationMessage>();
        if (errors != null) {
            for (CdError cdError : errors) {
                messages.add(UxUtils.setupValidationMessage(context, babylon, cdError));
            }
        }
        return new UxValidationResult(messages);
    }

    public static UxValidationMessage setupValidationMessage(UxQueryContext context, OlapBabylonService babylon, CdError error) {
        return UxUtils.setupValidationMessage(context, babylon, error, "");
    }

    public static UxValidationMessage setupValidationMessage(UxQueryContext context, OlapBabylonService babylon, CdError error, String prefix) {
        String errCode = error.getCode().getValue();
        String errMessage = prefix + error.asMessage((CdBabylonService)babylon);
        UxJavaNativeErrors javaNativeErrors = UxUtils.setupJavaNativeErrors(babylon, error);
        UxMdxRange mdxRange = UxUtils.setupMdxRange(0, error.getErrorRange());
        String pathAsString = UxUtils.setupPathAsString(babylon, mdxRange, error.getLocation());
        UxValidationMessageRef ref = UxUtils.setupRef(context, error.getLocation(), mdxRange, javaNativeErrors);
        return new UxValidationMessage(errCode, errMessage, pathAsString, ref, mdxRange, javaNativeErrors);
    }

    @Nullable
    private static UxJavaNativeErrors setupJavaNativeErrors(OlapBabylonService babylon, CdError error) {
        if (error instanceof OlapBuilderJavaCompilationError) {
            OlapBuilderJavaCompilationError javaError = (OlapBuilderJavaCompilationError)error;
            String sourceCode = javaError.getSource();
            List compilationErrors = javaError.getCompilationError().getErrors();
            ArrayList<UxJavaNativeError> errors = new ArrayList<UxJavaNativeError>();
            for (CompilationException.Error compilationError : compilationErrors) {
                errors.add(new UxJavaNativeError(compilationError.getLineNumber(), compilationError.getStartPosition(), compilationError.getEndPosition(), compilationError.getErrorMessage()));
            }
            if (!errors.isEmpty()) {
                return new UxJavaNativeErrors(sourceCode, errors);
            }
        }
        return null;
    }

    @Nullable
    private static UxValidationMessageRef setupRef(UxQueryContext context, @Nullable CdErrorLocation location, @Nullable UxMdxRange errors, @Nullable UxJavaNativeErrors javaNativeErrors) {
        try {
            if (!(location instanceof OlapContextualErrorLocation)) {
                return null;
            }
            OlapContextualErrorLocation cLocation = (OlapContextualErrorLocation)location;
            IOlapContextual[] cPath = cLocation.getPath();
            if (cPath == null || cPath.length == 0) {
                return null;
            }
            IOlapContextual contextual = cPath[0];
            if (contextual instanceof OlapBuilderSchema) {
                UxValidationMessageRef messageRef = UxUtils.setupRefForSchema(context, cLocation, cPath, 1, (OlapBuilderSchema)contextual);
                if (messageRef != null) {
                    messageRef = messageRef.withUseCaseActive(!context.isSetupForScriptValidation()).withProperty(cLocation.getProperty()).withPropertyLocation(UxUtils.setupMdxRange(0, cLocation.getPropertyLocation())).withErrors(errors).withJavaNativeErrors(javaNativeErrors);
                }
                return messageRef;
            }
            return null;
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)"[ux.builder] could not setup the validation message ref.", (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static UxValidationMessageRef setupRefForSchema(UxQueryContext context, OlapContextualErrorLocation location, IOlapContextual[] path, int index, OlapBuilderSchema schema) {
        File xmlFile = schema.getXmlFile();
        if (xmlFile == null) {
            OlapLoggers.BUILDER.info((Object)("[builder] could not get factory file for schema : " + schema.getName()));
            return null;
        }
        UxSchemaFactoryFile factoryFile = UxSchemaFactoryFile.fromFile(context, true, xmlFile);
        try {
            OlapFile file = factoryFile.asOlapFile();
            if (!file.__getUnderlying().exists()) {
                OlapLoggers.BUILDER.info((Object)("[builder] could not get factory file : " + String.valueOf(file)));
                return null;
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.info((Object)("[builder] could not get factory file for schema : " + schema.getName()), (Throwable)ex);
            return null;
        }
        UxSchemaId schemaId = new UxSchemaId(schema.getName(), factoryFile.relativePath());
        if (index >= path.length) {
            CdProperty property = location.getProperty();
            if (property != null) {
                UxUseCase useCase = context.getUseCase(UxBuilderUseCaseName.SchemaProps, schemaId);
                return UxUtils.createValidationMessageRef(useCase);
            }
            return null;
        }
        IOlapContextual contextual = path[index];
        if (contextual instanceof IOlapBuilderDataSource) {
            return UxUtils.setupRefForDataSource(context, path, index + 1, schemaId, (IOlapBuilderDataSource)contextual);
        }
        if (contextual instanceof IOlapBuilderDataViewDef) {
            return UxUtils.setupRefForDataView(context, path, index + 1, schemaId, (IOlapBuilderDataViewDef)contextual);
        }
        if (contextual instanceof IOlapBuilderLocalizationDef) {
            return UxUtils.setupRefForLocalization(context, path, index + 1, schemaId, (IOlapBuilderLocalizationDef)contextual);
        }
        if (contextual instanceof IOlapBuilderCubeDef) {
            return UxUtils.setupRefForCube(context, path, index + 1, schemaId, (IOlapBuilderCubeDef)contextual);
        }
        if (contextual instanceof IOlapBuilderPerspectiveDef) {
            return UxUtils.setupRefForPerspective(context, path, index + 1, schemaId, (IOlapBuilderPerspectiveDef)contextual);
        }
        if (contextual instanceof IOlapBuilderScriptDef) {
            return UxUtils.setupRefForScript(context, path, index + 1, schemaId, (IOlapBuilderScriptDef)contextual);
        }
        if (contextual instanceof IOlapBuilderDimensionDef) {
            return UxUtils.setupRefForDimension(context, path, index + 1, schemaId, (IOlapBuilderDimensionDef)contextual);
        }
        return null;
    }

    private static UxValidationMessageRef setupRefForDimension(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDimensionDef dimension) {
        IOlapContextual contextual;
        String dimensionName = dimension.getName();
        if (CdStringUtils.isNullOrBlank((String)dimensionName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderHierarchyDef) {
            return UxUtils.setupRefForHierarchy(context, path, index + 1, schemaId, dimension, (IOlapBuilderHierarchyDef)contextual);
        }
        UxUseCase useCase = UxDimensionQueryMeta.createUseCase(context, schemaId, null, UxBuilderDimensionUniqueName.create(dimension), dimension.withCreateHierarchy());
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForHierarchy(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy) {
        IOlapContextual contextual;
        String hierarchyName = dimension.getName();
        if (CdStringUtils.isNullOrBlank((String)hierarchyName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderHierarchyLevelDef) {
            return UxUtils.setupRefForLevel(context, path, index + 1, schemaId, dimension, hierarchy, (IOlapBuilderHierarchyLevelDef)contextual);
        }
        UxUseCase useCase = UxHierarchyQueryMeta.createUseCase(context, schemaId, null, UxBuilderHierarchyUniqueName.create(dimension, hierarchy), hierarchy.withCreateLevel());
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForLevel(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDimensionDef dimension, IOlapBuilderHierarchyDef hierarchy, IOlapBuilderHierarchyLevelDef level) {
        IOlapContextual contextual;
        String levelName = dimension.getName();
        if (CdStringUtils.isNullOrBlank((String)levelName)) {
            return null;
        }
        if (index >= path.length || (contextual = path[index]) instanceof IOlapBuilderPropertyDef) {
            // empty if block
        }
        UxUseCase useCase = UxLevelQueryMeta.createUseCase(context, schemaId, UxBuilderLevelUniqueName.create(dimension, hierarchy, (IOlapBuilderBaseHierarchyLevelDef)level));
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForDataSource(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDataSource dataSource) {
        IOlapContextual contextual;
        String dataSourceName = dataSource.getName();
        if (CdStringUtils.isNullOrBlank((String)dataSourceName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderDataTableDef) {
            return UxUtils.setupRefForDataTable(context, path, index + 1, schemaId, dataSource, (IOlapBuilderDataTableDef)contextual);
        }
        UxUseCase useCase = UxDataSourceQueryMeta.createUseCase(context, schemaId, dataSourceName, null);
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForDataTable(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDataSource dataSource, IOlapBuilderDataTableDef dataTable) {
        IOlapContextual contextual;
        String dataTableName = dataTable.getName();
        if (CdStringUtils.isNullOrBlank((String)dataTableName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderDataColumnDef) {
            IOlapBuilderDataColumnDef column = (IOlapBuilderDataColumnDef)contextual;
            UxUseCase useCase = UxDataTableQueryMeta.createUseCase(context, schemaId, null, null, UxBuilderTablePathName.create(dataSource, dataTable));
            return UxUtils.createValidationMessageRef(useCase);
        }
        UxUseCase useCase = UxDataTableQueryMeta.createUseCase(context, schemaId, null, null, UxBuilderTablePathName.create(dataSource, dataTable));
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForDataView(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderDataViewDef dataView) {
        String dataViewName = dataView.getName();
        if (CdStringUtils.isNullOrBlank((String)dataViewName)) {
            return null;
        }
        UxUseCase useCase = UxDataViewQueryMeta.createUseCase(context, schemaId, null, null, dataViewName, null);
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForLocalization(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderLocalizationDef localization) {
        UxUseCase useCase = context.getUseCase(UxBuilderUseCaseName.SchemaLocalization, schemaId);
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForCube(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderCubeDef cube) {
        IOlapContextual contextual;
        String cubeName = cube.getName();
        if (CdStringUtils.isNullOrBlank((String)cubeName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderBaseFactsDef) {
            return UxUtils.setupRefForFacts(context, path, index + 1, schemaId, cube, (IOlapBuilderBaseFactsDef)contextual);
        }
        UxUseCase useCase = UxCubeQueryMeta.createUseCase(context, schemaId, null, UxBuilderCubeUniqueName.create(cube));
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForFacts(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef facts) {
        IOlapContextual contextual;
        String factsName = facts.getName();
        if (CdStringUtils.isNullOrBlank((String)factsName)) {
            return null;
        }
        if (index < path.length && (contextual = path[index]) instanceof IOlapBuilderMeasureDef) {
            return UxUtils.setupRefForMeasure(context, path, index + 1, schemaId, cube, facts, (IOlapBuilderMeasureDef)contextual);
        }
        UxUseCase useCase = UxMeasureGroupQueryMeta.createUseCase(context, schemaId, null, UxBuilderMeasureGroupUniqueName.create(cube, facts));
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForMeasure(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderCubeDef cube, IOlapBuilderBaseFactsDef facts, IOlapBuilderMeasureDef measure) {
        String measureName = facts.getName();
        if (CdStringUtils.isNullOrBlank((String)measureName)) {
            return null;
        }
        if (index < path.length) {
            // empty if block
        }
        UxUseCase useCase = UxMeasureQueryMeta.createUseCase(context, schemaId, null, UxBuilderMeasureUniqueName.create(cube, facts, measure));
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForPerspective(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderPerspectiveDef perspective) {
        String perspectiveName = perspective.getName();
        if (CdStringUtils.isNullOrBlank((String)perspectiveName)) {
            return null;
        }
        if (index < path.length) {
            // empty if block
        }
        UxUseCase useCase = UxPerspectiveQueryMeta.createUseCase(context, schemaId, perspectiveName);
        return UxUtils.createValidationMessageRef(useCase);
    }

    private static UxValidationMessageRef setupRefForScript(UxQueryContext context, IOlapContextual[] path, int index, UxSchemaId schemaId, IOlapBuilderScriptDef script) {
        if (index < path.length) {
            // empty if block
        }
        UxUseCase useCase = context.getUseCase(UxBuilderUseCaseName.SchemaScript, schemaId);
        return UxUtils.createValidationMessageRef(useCase);
    }

    @Nullable
    private static UxValidationMessageRef createValidationMessageRef(@Nullable UxUseCase useCase) {
        if (useCase != null) {
            return new UxValidationMessageRef(useCase);
        }
        return null;
    }

    @Nullable
    private static String setupPathAsString(OlapBabylonService babylon, @Nullable UxMdxRange range, @Nullable CdErrorLocation location) {
        if (location instanceof OlapContextualErrorLocation) {
            List<UxMdxRangeRegion> regions;
            OlapContextualErrorLocation contextualLocation = (OlapContextualErrorLocation)location;
            Object path = contextualLocation.asString((CdBabylonService)babylon);
            if (range != null && (regions = range.getRegions()) != null && !regions.isEmpty()) {
                UxMdxRangeRegion firstRegion = regions.get(0);
                int lineNumber = firstRegion.getLineNumber();
                path = (String)path + ".line." + lineNumber;
            }
            return path;
        }
        return null;
    }

    @Nullable
    public static UxMdxRange setupMdxRange(int scriptOffset, @Nullable GwtMdxQueryRange location) {
        if (location == null) {
            return null;
        }
        GwtMdxQueryRangeRegion[] regions_ = location.getRegions();
        if (regions_ == null || regions_.length == 0) {
            return null;
        }
        if (scriptOffset < 0) {
            scriptOffset = 0;
        }
        ArrayList<UxMdxRangeRegion> regions = new ArrayList<UxMdxRangeRegion>();
        for (GwtMdxQueryRangeRegion region_ : regions_) {
            regions.add(new UxMdxRangeRegion(scriptOffset + region_.from, scriptOffset + region_.to, region_.lineNumber));
        }
        return new UxMdxRange(regions);
    }

    @Nullable
    public static UxMdxRange setupMdxRange(int scriptOffset, @Nullable CdErrorLocation location) {
        if (location == null) {
            return null;
        }
        if (scriptOffset < 0) {
            scriptOffset = 0;
        }
        if (location instanceof CdMdxTokenLocationRange) {
            CdMdxTokenLocationRange tokenLocation = (CdMdxTokenLocationRange)location;
            return new UxMdxRange(scriptOffset + tokenLocation.from(), scriptOffset + tokenLocation.to(), tokenLocation.lineNumber());
        }
        if (location instanceof MdxParserTokenLocationRange) {
            MdxParserTokenLocationRange tokenLocation = (MdxParserTokenLocationRange)location;
            return new UxMdxRange(scriptOffset + tokenLocation.from(), scriptOffset + tokenLocation.to(), tokenLocation.lineNumber());
        }
        if (location instanceof OlapInstrLocationRange) {
            OlapInstrLocationRange instrLocation = (OlapInstrLocationRange)location;
            return new UxMdxRange(scriptOffset + instrLocation.from(), scriptOffset + instrLocation.to(), instrLocation.lineNumber());
        }
        if (location instanceof OlapInstrLocationRanges) {
            OlapInstrLocationRanges instrLocation = (OlapInstrLocationRanges)location;
            List ranges = instrLocation.getRanges();
            ArrayList<UxMdxRangeRegion> regions = new ArrayList<UxMdxRangeRegion>();
            for (OlapInstrLocationRange range : ranges) {
                regions.add(new UxMdxRangeRegion(scriptOffset + range.from(), scriptOffset + range.to(), range.lineNumber()));
            }
            return new UxMdxRange(regions);
        }
        return null;
    }
}

