/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.usecase.repository;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.admin.usecase.UxAdminUseCaseName;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.usecase.UxUseCaseName;
import crazydev.iccube.ux.common.usecase.repository.UxSearchMatch;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class UxUseCaseRepository {
    private final List<UxUseCase> useCases = new ArrayList<UxUseCase>();
    private final List<UxUseCase> unlistedUseCases = new ArrayList<UxUseCase>();
    private final UxQueryContext queryContext;

    protected UxUseCaseRepository(UxQueryContext queryContext) {
        this.queryContext = queryContext;
        OlapLoggers.UX_REQUEST.info((Object)("[UX] create repository : " + this.getType()));
    }

    protected void registerActions(UxQueryContext context) {
        this.registerActions(context, this.useCases);
        this.registerActions(context, this.unlistedUseCases);
    }

    protected void registerActions(UxQueryContext context, List<UxUseCase> useCases) {
        for (UxUseCase useCase : useCases) {
            useCase.setupActions(context, null);
        }
    }

    protected abstract String getType();

    public static UxUrl asBookmark(UxUrl url) {
        return url.asBookmark();
    }

    public List<UxUseCase> getUseCases() {
        return this.useCases;
    }

    @Nullable
    public UxUseCase getUseCase(UxUseCaseName useCaseName) {
        UxUseCase useCase = UxUseCaseRepository.getUseCase(this.useCases, useCaseName);
        if (useCase != null) {
            return useCase;
        }
        return UxUseCaseRepository.getUseCase(this.unlistedUseCases, useCaseName);
    }

    @Nullable
    private static UxUseCase getUseCase(List<UxUseCase> useCases, UxUseCaseName useCaseName) {
        for (UxUseCase useCase : useCases) {
            if (!useCase.id().equals(useCaseName.name())) continue;
            return useCase;
        }
        return null;
    }

    public List<UxSearchMatch> search(String input) {
        ArrayList<UxSearchMatch> match = new ArrayList<UxSearchMatch>();
        if (CdStringUtils.isNullOrBlank((String)input)) {
            return match;
        }
        String inputL = input.toLowerCase();
        this.searchUseCases(match, this.useCases, inputL);
        this.searchUseCases(match, this.unlistedUseCases, inputL);
        this.searchUseCasesActions(match, this.useCases, inputL);
        this.searchUseCasesActions(match, this.unlistedUseCases, inputL);
        return match;
    }

    private void searchUseCasesActions(List<UxSearchMatch> match, List<UxUseCase> useCases, String inputL) {
        for (UxUseCase useCase : useCases) {
            List<UxAction> actions = useCase.getActions();
            if (actions == null) continue;
            for (UxAction action : actions) {
                String searchText = action.captionSearch();
                if (!CdStringUtils.isNotNullAndNotBlank((String)searchText) || !searchText.toLowerCase().contains(inputL)) continue;
                match.add(new UxSearchMatch(useCase, action));
            }
        }
    }

    private void searchUseCases(List<UxSearchMatch> match, List<UxUseCase> useCases, String inputL) {
        for (UxUseCase useCase : useCases) {
            if (!useCase.isSearchable()) continue;
            if (useCase.caption().toLowerCase().contains(inputL)) {
                match.add(new UxSearchMatch(useCase));
                continue;
            }
            String captionEx = useCase.captionEx();
            if (captionEx == null || !captionEx.toLowerCase().contains(inputL)) continue;
            match.add(new UxSearchMatch(useCase));
        }
    }

    protected void register(UxUseCaseName id, UxQueryMeta queryMeta) {
        this.register(new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).build(false));
    }

    protected void register(UxUseCaseName id, UxQueryMeta queryMeta, int orderInGroup) {
        this.register(new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).withOrderInGroup(orderInGroup).build(false));
    }

    protected void register(UxUseCaseName id, UxQueryMeta queryMeta, UxUrl url, @Nullable List<UxAction> actions) {
        this.register(new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).withUrl(url).withActions(actions).build(false));
    }

    protected void register(UxUseCaseName id, UxQueryMeta queryMeta, UxUrl url, @Nullable List<UxAction> actions, int orderInGroup) {
        this.register(new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).withUrl(url).withActions(actions).withOrderInGroup(orderInGroup).build(false));
    }

    protected void registerU(UxUseCaseName id, UxQueryMeta queryMeta) {
        this.register(true, new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).build(false));
    }

    protected void registerHIDDEN(UxAdminUseCaseName id, UxQueryMeta queryMeta, UxUrl url, @Nullable List<UxAction> actions) {
        this.register(true, new UxUseCaseBuilder(this.queryContext, queryMeta).withId(id).withUrl(url).withActions(actions).build(false, false));
    }

    protected void register(@Nullable UxUseCase useCase) {
        this.register(false, useCase);
    }

    protected void register(boolean unlisted, @Nullable UxUseCase useCase) {
        if (useCase == null) {
            return;
        }
        if (unlisted) {
            this.unlistedUseCases.add(useCase);
        } else {
            this.useCases.add(useCase);
        }
    }
}

