/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.usecase;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderCubeDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.impl.hierarchy.IOlapBuilderBaseHierarchyLevelDef;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.builder.UxSchemaBuilderQueryMeta;
import crazydev.iccube.ux.builder.common.UxLazyTreeKind;
import crazydev.iccube.ux.builder.common.UxLazyTreeStatus;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.model.UxBuilderCubeUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderDimensionUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderHierarchyUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderLevelUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureGroupUniqueName;
import crazydev.iccube.ux.builder.model.UxBuilderMeasureUniqueName;
import crazydev.iccube.ux.builder.model.UxExtraNavigationTree;
import crazydev.iccube.ux.builder.queries.cube.UxCubeQueryMeta;
import crazydev.iccube.ux.builder.queries.dimension.UxDimensionQueryMeta;
import crazydev.iccube.ux.builder.queries.facts.UxMeasureGroupQueryMeta;
import crazydev.iccube.ux.builder.queries.hierarchy.UxHierarchyQueryMeta;
import crazydev.iccube.ux.builder.queries.level.UxLevelQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxMeasureQueryMeta;
import crazydev.iccube.ux.builder.queries.measures.UxMeasuresQueryMeta;
import crazydev.iccube.ux.builder.queries.semanticlayer.UxSemanticLayerQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.action.UxActionSetup;
import crazydev.iccube.ux.common.action.UxActionUtils;
import crazydev.iccube.ux.common.file.UxFileUploadMeta;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.url.UxUrl;
import crazydev.iccube.ux.common.usecase.UxUseCaseRef;
import crazydev.iccube.ux.common.usecase.UxUseCaseTitle;
import crazydev.iccube.ux.console.UxConsoleConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxUseCase
implements UxSerializable {
    public static final int FLAG_HOME = 1;
    public static final int FLAG_SCHEMA = 2;
    public static final int FLAG_EXTRA_NAVIGATION = 4;
    public static Comparator<UxUseCase> MENU_COMPARATOR = (u1, u2) -> {
        String g1 = u1.group[1];
        String g2 = u2.group[1];
        int cmp = g1.compareTo(g2);
        if (cmp == 0) {
            int o1 = u1.orderInGroup;
            int o2 = u2.orderInGroup;
            if (o1 != -1 && o2 != -1 && o1 != o2) {
                return Integer.compare(o1, o2);
            }
            String c1 = u1.caption;
            String c2 = u2.caption;
            return c1.compareToIgnoreCase(c2);
        }
        return cmp;
    };
    private final transient UxQueryMeta meta;
    @Nullable
    private final String uuid;
    private final String id;
    @Nullable
    private final String schemaName;
    private final int attrs;
    private String caption;
    @Nullable
    private final String captionEx;
    @Nullable
    private String captionTooltip;
    private final String[] group;
    private final int orderInGroup;
    @Nullable
    private final UxUseCaseRef parentUseCase;
    private final UxUrl url;
    private final UxUrl bookmark;
    @Nullable
    private final UxUrl bookmarkH;
    @Nullable
    private final UxUseCaseTitle extraTitle;
    @Nullable
    private final UxFileUploadMeta fileUpload;
    @Nullable
    private final String helpUrl;
    @Nullable
    private final String helpTooltip;
    private final boolean searchable;
    @Nullable
    private String extraNavigationKeyId;
    @Nullable
    private String extraNavigationKeyId_;
    private boolean withExtraNavigation;
    @Nullable
    private List<UxAction> actions;

    public UxUseCase(UxQueryMeta meta, @Nullable String uuid, String id, @Nullable String parentId, @Nullable String extraNavigationKeyId, @Nullable String extraNavigationKeyId_, @Nullable String schemaName, int attrs, String caption, @Nullable String captionEx, @Nullable String captionTooltip, String[] group, int orderInGroup, UxUrl url, UxUrl bookmark, @Nullable UxUrl bookmarkH, @Nullable UxUseCaseTitle extraTitle, @Nullable UxExtraNavigationTree extraNavigation, @Nullable List<UxAction> actions, @Nullable UxFileUploadMeta fileUpload, @Nullable String helpUrl, @Nullable String helpTooltip, boolean searchable) {
        this.meta = meta;
        this.uuid = uuid;
        this.id = id;
        this.schemaName = schemaName;
        this.attrs = attrs;
        this.caption = caption;
        this.captionEx = captionEx;
        this.captionTooltip = captionTooltip;
        this.group = group != null ? group : new String[]{};
        this.orderInGroup = orderInGroup;
        this.url = url;
        this.bookmark = bookmark;
        this.bookmarkH = bookmarkH;
        this.actions = UxActionUtils.removeNulls(actions);
        this.extraTitle = extraTitle;
        this.parentUseCase = parentId != null ? new UxUseCaseRef(parentId) : (this.extraTitle != null && this.extraTitle.getParentUseCase() != null ? new UxUseCaseRef(this.extraTitle.getParentUseCase().id) : null);
        this.withExtraNavigation = this.setupWithExtraNavigation(id, parentId);
        this.extraNavigationKeyId = extraNavigationKeyId;
        this.extraNavigationKeyId_ = extraNavigationKeyId_;
        this.fileUpload = fileUpload;
        this.helpUrl = helpUrl;
        this.helpTooltip = helpTooltip;
        this.searchable = searchable;
    }

    private boolean setupWithExtraNavigation(String id, @Nullable String parentId) {
        String semanticLayer = UxSemanticLayerQueryMeta.SemanticLayer.queryName().name();
        String measures = UxMeasuresQueryMeta.Measures.queryName().name();
        return id.equals(semanticLayer) || id.equals(measures) || parentId != null && (parentId.equals(semanticLayer) || parentId.equals(measures));
    }

    public void setupActions(UxQueryContext context, @Nullable UxSchemaId schemaId) {
        if (this.actions == null) {
            if (this.meta instanceof UxSchemaBuilderQueryMeta) {
                try {
                    this.actions = ((UxSchemaBuilderQueryMeta)this.meta).createActions(context, schemaId);
                }
                catch (UxBuilderSchemaServiceException ex) {
                    OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] could not setup the actions for use-case [" + this.id + "]"), (Throwable)ex);
                }
            } else {
                this.actions = this.meta.createActions(context);
            }
        }
    }

    @Nullable
    public UxExtraNavigationTree setupExtraNavigation(UxQueryContext context, UxSchemaId schemaId, boolean currentUseCaseWithSemanticLayerExtraNavigation, boolean currentUseCaseWithMeasuresExtraNavigation) {
        try {
            if (currentUseCaseWithSemanticLayerExtraNavigation) {
                return this.setupSemanticLayerExtraNavigation(context, schemaId);
            }
            if (currentUseCaseWithMeasuresExtraNavigation) {
                return this.setupMeasuresExtraNavigation(context, schemaId);
            }
            return null;
        }
        catch (RuntimeException ex) {
            OlapLoggers.UX_REQUEST_BUILDER.error((Object)("[ux.builder] extra navigation setup [" + this.id + "] error"), (Throwable)ex);
            throw ex;
        }
    }

    @Nullable
    private UxExtraNavigationTree setupSemanticLayerExtraNavigation(UxQueryContext context, UxSchemaId schemaId) {
        String uiNavTreeUUID = context.getNavTreeUUID();
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] setupExtraNavigation( " + String.valueOf((Object)this.meta.queryName()) + " ) [navTreeUUID:" + uiNavTreeUUID + "]"));
        UxBuilderSchemaService service = context.getPersistentSchemaService();
        return service.readSchema(schemaId, -1, (lock, schema) -> {
            UxLazyTreeKind treeKind = UxLazyTreeKind.SEMANTIC_LAYER;
            int schemaRevNumber = schema.getRevNumber();
            String treeUUID = "ic3-semantic-layer-" + schemaRevNumber;
            if (uiNavTreeUUID != null && uiNavTreeUUID.equals(treeUUID)) {
                OlapLoggers.UX_REQUEST.debug((Object)("[UX] setupExtraNavigation( " + String.valueOf((Object)this.meta.queryName()) + " ) not required for [" + uiNavTreeUUID + "]"));
                return new UxExtraNavigationTree(UxLazyTreeStatus.UNCHANGED, treeKind, treeUUID, null, null, null);
            }
            return schema.getSemanticLayerExtraNavigation(context, lock, schemaId, treeKind, treeUUID, beans -> {
                if (beans != null) {
                    if (beans.length == 1) {
                        IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)beans[0];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxDimensionQueryMeta.createUseCase(context, withActions, schemaId, null, UxBuilderDimensionUniqueName.create(dimension), dimension.withCreateHierarchy());
                    }
                    if (beans.length == 2) {
                        IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)beans[0];
                        IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)beans[1];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxHierarchyQueryMeta.createUseCase(context, withActions, schemaId, null, UxBuilderHierarchyUniqueName.create(dimension, hierarchy), hierarchy.withCreateLevel());
                    }
                    if (beans.length == 3) {
                        IOlapBuilderDimensionDef dimension = (IOlapBuilderDimensionDef)beans[0];
                        IOlapBuilderHierarchyDef hierarchy = (IOlapBuilderHierarchyDef)beans[1];
                        IOlapBuilderBaseHierarchyLevelDef level = (IOlapBuilderBaseHierarchyLevelDef)beans[2];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxLevelQueryMeta.createUseCase(context, withActions, schemaId, UxBuilderLevelUniqueName.create(dimension, hierarchy, level));
                    }
                }
                return null;
            });
        });
    }

    @Nullable
    private UxExtraNavigationTree setupMeasuresExtraNavigation(UxQueryContext context, UxSchemaId schemaId) {
        String uiNavTreeUUID = context.getNavTreeUUID();
        OlapLoggers.UX_REQUEST.debug((Object)("[UX] setupExtraNavigation( " + String.valueOf((Object)this.meta.queryName()) + " ) [navTreeUUID:" + uiNavTreeUUID + "]"));
        UxBuilderSchemaService service = context.getPersistentSchemaService();
        return service.readSchema(schemaId, -1, (lock, schema) -> {
            UxLazyTreeKind treeKind = UxLazyTreeKind.MEASURES;
            int schemaRevNumber = schema.getRevNumber();
            String treeUUID = "ic3-measures-" + schemaRevNumber;
            if (uiNavTreeUUID != null && uiNavTreeUUID.equals(treeUUID)) {
                OlapLoggers.UX_REQUEST.debug((Object)("[UX] setupExtraNavigation( " + String.valueOf((Object)this.meta.queryName()) + " ) not required for [" + uiNavTreeUUID + "]"));
                return new UxExtraNavigationTree(UxLazyTreeStatus.UNCHANGED, treeKind, treeUUID, null, null, null);
            }
            return schema.getMeasuresExtraNavigation(context, lock, schemaId, treeKind, treeUUID, beans -> {
                if (beans != null) {
                    if (beans.length == 1) {
                        IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)beans[0];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxCubeQueryMeta.createUseCase(context, withActions, schemaId, null, UxBuilderCubeUniqueName.create(cube));
                    }
                    if (beans.length == 2) {
                        IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)beans[0];
                        IOlapBuilderBaseFactsDef measureGroup = (IOlapBuilderBaseFactsDef)beans[1];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxMeasureGroupQueryMeta.createUseCase(context, withActions, schemaId, null, UxBuilderMeasureGroupUniqueName.create(cube, measureGroup));
                    }
                    if (beans.length == 3) {
                        IOlapBuilderCubeDef cube = (IOlapBuilderCubeDef)beans[0];
                        IOlapBuilderBaseFactsDef measureGroup = (IOlapBuilderBaseFactsDef)beans[1];
                        IOlapBuilderMeasureDef measure = (IOlapBuilderMeasureDef)beans[2];
                        UxActionSetup withActions = UxActionSetup.NAVIGATION_TREE;
                        return UxMeasureQueryMeta.createUseCase(context, withActions, schemaId, null, UxBuilderMeasureUniqueName.create(cube, measureGroup, measure));
                    }
                }
                return null;
            });
        });
    }

    public UxQueryMeta meta() {
        return this.meta;
    }

    public String id() {
        return this.id;
    }

    public String caption() {
        return this.caption;
    }

    @Nullable
    public String captionEx() {
        return this.captionEx;
    }

    public String captionForSearchSuggestion() {
        return CdStringUtils.isNotNullAndNotBlank((String)this.captionEx) ? this.captionEx : this.caption;
    }

    public UxUrl url() {
        return this.url;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isSchemaDefRevisions() {
        return UxConsoleConstants.QueryName.SchemaDefRevisions.equals((Object)this.meta.queryName());
    }

    public void addActions(@Nullable UxAction action) {
        if (action == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<UxAction>();
        }
        this.actions.add(action);
    }

    @Nullable
    public List<UxAction> getActions() {
        return this.actions;
    }

    public int getAttrs() {
        return this.attrs;
    }

    @Nullable
    public UxUseCaseRef getParentUseCase() {
        return this.parentUseCase;
    }

    @Nullable
    public String getExtraNavigationKeyId() {
        return this.extraNavigationKeyId;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCaptionTooltip(@Nullable String captionTooltip) {
        this.captionTooltip = captionTooltip;
    }

    public String toString() {
        return this.group[1] + "." + this.caption;
    }
}

