/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.url;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import crazydev.common.collection.CdStrPair;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.fs.OlapPathX;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.URIUtil;
import org.jetbrains.annotations.Nullable;

public class UxUrl {
    private final String[] parts;
    @Nullable
    private final CdStrPair[] params;

    public UxUrl(String ... parts) {
        this(parts, (CdStrPair[])null);
    }

    public UxUrl(String[] parts, @Nullable CdStrPair[] params) {
        this.parts = parts;
        this.params = params;
        for (int ii = 0; ii < parts.length; ++ii) {
            if (parts[ii] != null) continue;
            parts[ii] = "";
        }
    }

    @Nullable
    public static UxUrl fromOlapPath(OlapPath path) {
        if (path == null) {
            return null;
        }
        return new UxUrl(path.toRawPath());
    }

    @Nullable
    public static UxUrl fromOlapPath(OlapPathX path) {
        if (path == null) {
            return null;
        }
        return new UxUrl(path.getPath().toRawPath(), path.getParams());
    }

    public UxUrl addPart(String ... parts) {
        String[] parts_ = new String[this.parts.length + parts.length];
        System.arraycopy(this.parts, 0, parts_, 0, this.parts.length);
        System.arraycopy(parts, 0, parts_, this.parts.length, parts.length);
        return new UxUrl(parts_, this.params);
    }

    public UxUrl addParam(UxSchemaId value) {
        UxUrl url = this;
        if (CdStringUtils.isNotNullAndNotBlank((String)value.schemaName)) {
            url = url.addParam("schemaName", value.schemaName);
        }
        if (CdStringUtils.isNotNullAndNotBlank((String)value.schemaFile)) {
            url = url.addParam("schemaFile", value.schemaFile);
        }
        return url;
    }

    public UxUrl addParam(String name, OlapPath path) {
        return this.addParam(name, path.toSimplePath());
    }

    public UxUrl addParam(String name, @Nullable UxDocsEntryPath path) {
        if (path != null) {
            return this.addParam(name, path.toOlapPath());
        }
        return this;
    }

    public UxUrl addParam(String name, String value) {
        CdStrPair[] params_;
        if (this.params == null) {
            params_ = new CdStrPair[1];
        } else {
            params_ = new CdStrPair[this.params.length + 1];
            System.arraycopy(this.params, 0, params_, 0, this.params.length);
        }
        params_[params_.length - 1] = new CdStrPair(name, value);
        return new UxUrl(this.parts, params_);
    }

    public UxUrl asBookmark() {
        boolean hasUX = false;
        for (String part : this.parts) {
            if (!part.equals("ux-api")) continue;
            hasUX = true;
            break;
        }
        if (!hasUX) {
            return this;
        }
        String[] parts_ = new String[this.parts.length - 1];
        int pos = 0;
        for (String part : this.parts) {
            if (part.equals("ux-api") || part.equals("ux-api-dev")) continue;
            parts_[pos++] = part;
        }
        return new UxUrl(parts_, this.params);
    }

    public String toUrl() {
        StringBuilder sb = new StringBuilder(64);
        for (String part : this.parts) {
            sb.append("/");
            sb.append(URIUtil.encodePath((String)part).replace("/", "%2F"));
        }
        if (this.params != null) {
            for (int ii = 0; ii < this.params.length; ++ii) {
                CdStrPair param = this.params[ii];
                if (param == null || param.fst == null) continue;
                if (ii == 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append((String)param.fst).append("=").append(param.snd != null ? URLEncoder.encode((String)param.snd, StandardCharsets.UTF_8) : "");
            }
        }
        return sb.toString();
    }

    public static class Serializer
    implements JsonSerializer<UxUrl> {
        public JsonElement serialize(UxUrl src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toUrl());
        }
    }
}

