/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.type;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.admin.queries.runtime.logs.UxLogLevel;
import crazydev.iccube.ux.common.field.UxHelpText;
import crazydev.iccube.ux.common.type.UxImageRef;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Nullable;

public class UxEnumValue
implements UxSerializable {
    private final String value;
    private final String caption;
    @Nullable
    private final UxHelpText description;
    private final transient int order;
    private boolean disabled;
    @Nullable
    private UxImageRef image;

    public UxEnumValue(String value, String caption, @Nullable UxHelpText description) {
        this(value, caption, description, false, -1);
    }

    public UxEnumValue(String value, String caption, @Nullable UxHelpText description, @Nullable UxImageRef image) {
        this(value, caption, description, image, false, -1);
    }

    public UxEnumValue(String value, String caption, @Nullable UxHelpText description, boolean disabled, int order) {
        this(value, caption, description, null, disabled, order);
    }

    public UxEnumValue(String value, String caption, @Nullable UxHelpText description, @Nullable UxImageRef image, boolean disabled, int order) {
        this.value = value;
        this.caption = caption;
        this.description = description;
        this.image = image;
        this.disabled = disabled;
        this.order = order;
    }

    public String getValue() {
        return this.value;
    }

    public String getCaption() {
        return this.caption;
    }

    public int getOrder() {
        return this.order;
    }

    public static UxEnumValue[] createSortedValues(UxBabylonService babylon, List<String> values, @Nullable List<String> captions) {
        UxEnumValue[] eValues = UxEnumValue.createValues(babylon, values, captions);
        return UxEnumValue.sortEnumValues(eValues);
    }

    public static <T> UxEnumValue[] createSortedValues(UxBabylonService babylon, Class<T> enumType, @Nullable Set<T> enabled, @Nullable Set<T> ignored) {
        UxEnumValue[] values = UxEnumValue.createValues(babylon, enumType, enabled, ignored);
        return UxEnumValue.sortEnumValues(values);
    }

    public static UxEnumValue[] createSortedValues(UxBabylonService babylon, Class<?> enumType) {
        UxEnumValue[] values = UxEnumValue.createValues(babylon, enumType, null, null);
        return UxEnumValue.sortEnumValues(values);
    }

    private static UxEnumValue[] sortEnumValues(UxEnumValue[] values) {
        Arrays.sort(values, (o1, o2) -> {
            if (o1.getOrder() != -1 && o2.getOrder() != -1) {
                int res = Integer.compare(o1.getOrder(), o2.getOrder());
                if (res == 0) {
                    return o1.getCaption().compareTo(o2.getCaption());
                }
                return res;
            }
            if (o1.getOrder() == -1 && o2.getOrder() == -1) {
                return o1.getCaption().compareToIgnoreCase(o2.getCaption());
            }
            if (o1.getOrder() == -1) {
                return 1;
            }
            return -1;
        });
        return values;
    }

    private static UxEnumValue[] createValues(UxBabylonService babylon, List<String> values, @Nullable List<String> captions) {
        UxEnumValue[] eValues = new UxEnumValue[values.size()];
        for (int ii = 0; ii < eValues.length; ++ii) {
            String value = values.get(ii);
            String caption = captions != null ? captions.get(ii) : value;
            UxHelpText description = null;
            eValues[ii] = new UxEnumValue(value, caption, description, false, ii);
        }
        return eValues;
    }

    private static <T> UxEnumValue[] createValues(UxBabylonService babylon, Class<T> enumType, @Nullable Set<T> enabled, @Nullable Set<T> ignored) {
        if (Level.class.isAssignableFrom(enumType)) {
            return UxEnumValue.createLevelValues(babylon);
        }
        if (Locale.class.isAssignableFrom(enumType)) {
            return UxEnumValue.createLocaleValues(babylon);
        }
        if (enumType.isEnum()) {
            return UxEnumValue.createEnumValues(babylon, enumType, enabled, ignored);
        }
        throw new RuntimeException("internal error: unsupported enum [" + enumType.getName() + "]");
    }

    private static UxEnumValue[] createLocaleValues(UxBabylonService babylon) {
        Locale[] locales = Locale.getAvailableLocales();
        ArrayList<Locale> sorted = new ArrayList<Locale>();
        for (Locale locale : locales) {
            if (!CdStringUtils.isNotNullAndNotBlank((String)locale.toString())) continue;
            sorted.add(locale);
        }
        UxEnumValue[] values = new UxEnumValue[sorted.size()];
        for (int ii = 0; ii < values.length; ++ii) {
            Locale locale = (Locale)sorted.get(ii);
            String name = locale.toString();
            String caption = locale.getDisplayName(babylon.getLocale());
            UxHelpText description = null;
            int order = -1;
            values[ii] = new UxEnumValue(name, caption, description, false, -1);
        }
        return values;
    }

    private static UxEnumValue[] createLevelValues(UxBabylonService babylon) {
        Level[] levels = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, Level.ALL, Level.OFF};
        UxEnumValue[] values = new UxEnumValue[levels.length];
        for (int ii = 0; ii < values.length; ++ii) {
            Level level = levels[ii];
            String value = level.toString();
            String caption = babylon.translateEnumCaption(UxLogLevel.class, value);
            UxHelpText description = null;
            int order = babylon.translateEnumOrder(UxLogLevel.class, value);
            values[ii] = new UxEnumValue(value, caption, description, false, order);
        }
        return values;
    }

    private static <T extends Enum> UxEnumValue[] createEnumValues(UxBabylonService babylon, Class<T> enumType, @Nullable Set<T> enabled, @Nullable Set<T> ignored) {
        int count;
        Enum[] modalities = (Enum[])enumType.getEnumConstants();
        if (ignored != null) {
            int modCount = 0;
            for (int ii = 0; ii < modalities.length; ++ii) {
                Enum modality = modalities[ii];
                if (ignored.contains(modality)) continue;
                ++modCount;
            }
            count = modCount;
        } else {
            count = modalities.length;
        }
        UxEnumValue[] values = new UxEnumValue[count];
        int valueIdx = 0;
        for (int ii = 0; ii < modalities.length; ++ii) {
            Enum modality = modalities[ii];
            if (ignored != null && ignored.contains(modality)) continue;
            String value = modality.name();
            String caption = babylon.translateEnumCaption(enumType, value);
            UxHelpText description = babylon.translateEnumDescriptionEx(enumType, value);
            boolean disabled = enabled != null && !enabled.contains(modality);
            int order = babylon.translateEnumOrder(enumType, value);
            values[valueIdx++] = new UxEnumValue(value, caption, description, disabled, order);
        }
        return values;
    }

    public String toString() {
        return this.caption + " [" + this.value + "]";
    }
}

