/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table.raw;

import crazydev.iccube.ux.UxRestReplyPayload;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.common.table.UxTableHeaders;
import crazydev.iccube.ux.common.table.UxTableOptions;
import crazydev.iccube.ux.common.table.UxTableRow;
import crazydev.iccube.ux.common.table.raw.UxRestTableHeader;
import crazydev.iccube.ux.common.table.raw.UxRestTableRow;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxRestTable
implements UxRestReplyPayload {
    @Nullable
    private final UxTableOptions options;
    private final UxRestTableHeader header;
    private final List<UxRestTableRow> rows;

    public UxRestTable(@Nullable UxTableOptions options, UxRestTableHeader header, List<UxRestTableRow> rows) {
        this.options = options;
        this.header = header;
        this.rows = rows;
    }

    public static UxRestTable create(@Nullable UxTableOptions optionsUI, @Nullable UxTableHeaders headerUI, List<UxTableRow> rowsUI) {
        UxRestTableHeader header = UxRestTable.setupHeader(headerUI);
        List<UxRestTableRow> rows = UxRestTable.setupRows(rowsUI);
        return new UxRestTable(optionsUI, header, rows);
    }

    private static UxRestTableHeader setupHeader(@Nullable UxTableHeaders headersUI) {
        UxTableHeader[] headers;
        ArrayList<String> names = new ArrayList<String>();
        if (headersUI != null && (headers = headersUI.getHeaders()) != null) {
            for (UxTableHeader col : headers) {
                names.add(col.getName());
            }
        }
        return new UxRestTableHeader(names);
    }

    private static List<UxRestTableRow> setupRows(List<UxTableRow> rowsUI) {
        ArrayList<UxRestTableRow> rows = new ArrayList<UxRestTableRow>();
        for (UxTableRow rowUI : rowsUI) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (UxTableCell cell : rowUI.getCells()) {
                row.add(cell.getValue());
            }
            rows.add(new UxRestTableRow(row));
        }
        return rows;
    }
}

