/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.style.UxStyle;
import crazydev.iccube.ux.common.style.UxStyleLevel;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.table.UxTableCell;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTableRow
implements UxSerializable {
    @Nullable
    private transient Object data;
    @Nullable
    private UxUseCase useCase;
    private final List<UxTableCell> cells;
    @Nullable
    private final UxStyle style;
    @Nullable
    private final String tooltip;

    public UxTableRow(List<UxTableCell> cells) {
        this(cells, null);
    }

    public UxTableRow(List<UxTableCell> cells, @Nullable UxStyle style) {
        this(cells, style, null);
    }

    public UxTableRow(List<UxTableCell> cells, @Nullable UxStyle style, @Nullable String tooltip) {
        UxUseCase useCase = null;
        int useCaseCount = 0;
        for (UxTableCell cell : cells) {
            UxUseCase cellUseCase = cell.getUseCase();
            if (cellUseCase == null) continue;
            useCase = cellUseCase;
            ++useCaseCount;
        }
        if (useCaseCount == 1) {
            cells.replaceAll(UxTableCell::withoutUseCase);
        } else {
            useCase = null;
        }
        this.useCase = useCase;
        this.cells = cells;
        this.style = style;
        this.tooltip = tooltip;
    }

    public UxTableRow(@Nullable UxUseCase useCase, List<UxTableCell> cells) {
        this(useCase, cells, null, null);
    }

    public UxTableRow(@Nullable UxUseCase useCase, List<UxTableCell> cells, @Nullable UxStyle style, @Nullable String tooltip) {
        this.useCase = useCase;
        this.cells = cells;
        this.style = style;
        this.tooltip = tooltip;
    }

    public boolean isOnError() {
        return this.style != null && this.style.isOnError();
    }

    @Nullable
    public <T> T getData() {
        return (T)this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
    }

    public void setUseCase(@Nullable UxUseCase useCase) {
        this.useCase = useCase;
    }

    public List<UxTableCell> getCells() {
        return this.cells;
    }

    public UxTableRow withStyle(@Nullable UxStyleLevel level) {
        return new UxTableRow(this.useCase, this.cells, UxStyle.override(this.style, level), this.tooltip);
    }

    public UxTableRow withStyle(UxStylePresentation presentation) {
        return new UxTableRow(this.useCase, this.cells, UxStyle.override(this.style, presentation), this.tooltip);
    }

    public UxTableRow withTooltip(String tooltip) {
        return new UxTableRow(this.useCase, this.cells, this.style, tooltip);
    }

    public static UxTableRow create(String name, String value) {
        return UxTableRow.create_(name, value);
    }

    public static UxTableRow createAsPre(String name, String value) {
        UxTableRow row = UxTableRow.create_(name, value);
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(row.cells.get(0).withStyle(UxStylePresentation.PRE));
        cells.add(row.cells.get(1).withStyle(UxStylePresentation.PRE));
        return new UxTableRow(cells, row.style);
    }

    public static UxTableRow createAsPreValue(String name, String value) {
        UxTableRow row = UxTableRow.create_(name, value);
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        cells.add(row.cells.get(0));
        cells.add(row.cells.get(1).withStyle(UxStylePresentation.PRE));
        return new UxTableRow(cells, row.style);
    }

    private static UxTableRow create_(Object ... elements) {
        if (elements == null || elements.length == 0) {
            throw new RuntimeException("internal error: unexpected empty row");
        }
        ArrayList<UxTableCell> cells = new ArrayList<UxTableCell>();
        for (int ii = 0; ii < elements.length; ++ii) {
            Object element = elements[ii];
            cells.add(new UxTableCell(element));
        }
        return new UxTableRow(cells, null);
    }
}

