/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.table.UxTableHeader;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class UxTableHeaders
implements UxSerializable {
    private UxTableHeader[] headers;

    public UxTableHeaders(UxTableHeader ... headers) {
        this.headers = headers;
    }

    public static UxTableHeaders create(UxBabylonService babylon, String ... names) {
        UxTableHeader[] headers = new UxTableHeader[names.length];
        for (int ii = 0; ii < headers.length; ++ii) {
            headers[ii] = new UxTableHeader(names[ii], babylon.translate(names[ii], new Serializable[0]));
        }
        return new UxTableHeaders(headers);
    }

    public void add(UxBabylonService babylon, String header) {
        UxTableHeader[] headers_ = new UxTableHeader[this.headers.length + 1];
        System.arraycopy(this.headers, 0, headers_, 0, this.headers.length);
        headers_[headers_.length - 1] = new UxTableHeader(header, babylon.translate(header, new Serializable[0]));
        this.headers = headers_;
    }

    public UxTableHeader[] getHeaders() {
        return this.headers;
    }

    @Nullable
    public UxTableHeader getHeader(String name) {
        for (int ii = 0; ii < this.headers.length; ++ii) {
            UxTableHeader header = this.headers[ii];
            if (!name.equals(header.getName())) continue;
            return header;
        }
        return null;
    }

    public int getHeaderIndex(String name) {
        for (int ii = 0; ii < this.headers.length; ++ii) {
            UxTableHeader header = this.headers[ii];
            if (!name.equals(header.getName())) continue;
            return ii;
        }
        return -1;
    }
}

