/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.field.UxFieldMeta;
import crazydev.iccube.ux.processor.UxBabylonService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTableHeader
implements UxSerializable {
    private final String name;
    private final String caption;
    @Nullable
    private final UxFieldMeta meta;
    @Nullable
    private final List<String[]> properties;

    public UxTableHeader(UxBabylonService babylon, IOlapBuilderDataColumnDef column) {
        this.name = column.getName();
        this.caption = column.getName();
        this.meta = null;
        this.properties = new ArrayList<String[]>();
        this.properties.add(new String[]{babylon.translate("type", new Serializable[0]), column.getType().name()});
        this.properties.add(new String[]{babylon.translate("tableType", new Serializable[0]), column.getTableType()});
        this.properties.add(new String[]{babylon.translate("isArray", new Serializable[0]), String.valueOf(column.getDecorationType() == OlapBuilderColumnDecorationType.ARRAY)});
        this.properties.add(new String[]{babylon.translate("nullObjectAsString", new Serializable[0]), column.getNullObjectAsString()});
    }

    public UxTableHeader(String name, String caption) {
        this(name, caption, null);
    }

    public UxTableHeader(String name, String caption, @Nullable UxFieldMeta meta) {
        this.name = name;
        this.caption = caption;
        this.meta = meta;
        this.properties = null;
    }

    public String getName() {
        return this.name;
    }
}

