/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.table;

import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.action.UxAction;
import crazydev.iccube.ux.common.style.UxStyle;
import crazydev.iccube.ux.common.style.UxStylePresentation;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxTableCell
implements UxSerializable {
    @Nullable
    private final Object value;
    @Nullable
    private final transient Object value_;
    @Nullable
    private final Object defaultValue;
    @Nullable
    private final UxStyle style;
    @Nullable
    private UxUseCase useCase;
    @Nullable
    private final List<UxAction> actions;

    public UxTableCell(@Nullable Object value) {
        this(value, (UxUseCase)null);
    }

    public UxTableCell(@Nullable Object value, @Nullable UxUseCase useCase) {
        this(value, null, useCase);
    }

    public UxTableCell(@Nullable Object value, @Nullable UxAction action) {
        this(value, null, action);
    }

    public UxTableCell(@Nullable Object value, @Nullable Object defaultValue) {
        this(value, defaultValue, (UxUseCase)null);
    }

    public UxTableCell(@Nullable Object value, @Nullable Object defaultValue, @Nullable UxUseCase useCase) {
        this(value, null, defaultValue, null, useCase, null);
    }

    public UxTableCell(@Nullable Object value, @Nullable Object defaultValue, @Nullable UxAction action) {
        this(value, null, defaultValue, null, null, action != null ? Collections.singletonList(action) : null);
    }

    public UxTableCell(@Nullable Object value, @Nullable Object value_, @Nullable Object defaultValue, @Nullable UxStyle style, @Nullable UxUseCase useCase, @Nullable List<UxAction> actions) {
        this.value = value;
        this.value_ = value_;
        this.defaultValue = defaultValue;
        this.style = style;
        this.useCase = useCase;
        this.actions = actions;
    }

    public static int compare(@Nullable UxTableCell cellL, @Nullable UxTableCell cellR) {
        Object cR;
        if (cellL == null) {
            if (cellR == null) {
                return 0;
            }
            return -1;
        }
        if (cellR == null) {
            return 1;
        }
        Object valueL = cellL.getSortingValue();
        Object valueR = cellR.getSortingValue();
        if (valueL == null) {
            if (valueR == null) {
                return 0;
            }
            return -1;
        }
        if (valueR == null) {
            return 1;
        }
        Object cL = valueL instanceof Comparable ? (Comparable)valueL : valueL.toString();
        Object object = cR = valueR instanceof Comparable ? (Comparable)valueR : valueR.toString();
        if (cL instanceof String && cR instanceof String) {
            return ((String)cL).compareToIgnoreCase((String)cR);
        }
        return cL.compareTo(cR);
    }

    public void setUseCase(UxUseCase useCase) {
        this.useCase = useCase;
    }

    @Nullable
    public UxUseCase getUseCase() {
        return this.useCase;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public Object getSortingValue() {
        Object v = this.value_ != null ? this.value_ : this.value;
        return v != null ? v : this.defaultValue;
    }

    public UxTableCell withoutUseCase() {
        return new UxTableCell(this.value, this.value_, this.defaultValue, this.style, null, this.actions);
    }

    public UxTableCell withStyle(UxStylePresentation presentation) {
        return new UxTableCell(this.value, this.value_, this.defaultValue, UxStyle.override(this.style, presentation), this.useCase, this.actions);
    }

    public UxTableCell withValue_(Object value_) {
        return new UxTableCell(this.value, value_, this.defaultValue, this.style, this.useCase, this.actions);
    }
}

