/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.common.reply;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.UxResultDockName;
import crazydev.iccube.ux.UxSerializable;
import crazydev.iccube.ux.common.action.UxActionContinuation;
import crazydev.iccube.ux.common.action.UxActionResultReplyPayload;
import crazydev.iccube.ux.common.action.UxActionStatus;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxErrorReplyPayload;
import crazydev.iccube.ux.common.reply.UxMessageReplyPayload;
import crazydev.iccube.ux.common.reply.UxOlapBabylonService;
import crazydev.iccube.ux.common.reply.UxPayloadReply;
import crazydev.iccube.ux.common.reply.UxValidationPayload;
import crazydev.iccube.ux.common.reply.payload.UxReplyPayload;
import crazydev.iccube.ux.common.reply.payload.UxReplyStatus;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.common.validation.UxValidationSynopsis;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class UxReply {
    public static final String CHARSET_ENCODING = "UTF-8";

    protected UxReply() {
    }

    public boolean isMdxOnError() {
        return false;
    }

    @Nullable
    public OlapSchemaLifeCycleStatus extractSchemaLifeCycleStatus() {
        return null;
    }

    public abstract void writeResponse(UxBabylonService var1, HttpServletRequest var2, HttpServletResponse var3, UxApi var4) throws IOException;

    public static UxReply actionStatus(UxActionStatus status) {
        return UxReply.success(new UxActionResultReplyPayload(status, null, null));
    }

    public static UxReply actionSuccess() {
        return UxReply.actionSuccess((UxActionResult)null);
    }

    public static UxReply actionSuccess(@Nullable Map<String, UxSerializable> extra) {
        return UxReply.actionSuccess(null, extra, null, null);
    }

    public static UxReply actionSuccess(@Nullable UxActionContinuation continuation) {
        return UxReply.actionSuccess(null, null, null, continuation);
    }

    public static UxReply actionSuccess(@Nullable Map<String, UxSerializable> extra, @Nullable UxActionResult result) {
        return UxReply.actionSuccess(result, extra, null, null);
    }

    public static UxReply actionSuccess(@Nullable UxActionResult result) {
        return UxReply.actionSuccess(result, null, null, null);
    }

    public static UxReply actionSuccess(@Nullable UxActionResult result, @Nullable UxResultDockName dockName) {
        return UxReply.actionSuccess(result, null, dockName, null);
    }

    public static UxReply actionSuccess(@Nullable UxActionResult result, @Nullable UxActionContinuation continuation) {
        return UxReply.actionSuccess(result, null, null, continuation);
    }

    public static UxReply actionSuccess(@Nullable UxActionResult result, @Nullable Map<String, UxSerializable> extra, @Nullable UxResultDockName dockName, @Nullable UxActionContinuation continuation) {
        if (result != null) {
            result.setDockName(dockName);
        }
        return UxReply.success(new UxActionResultReplyPayload(result, extra, continuation));
    }

    public static UxReply success(UxReplyPayload payload) {
        return new UxPayloadReply(UxReplyStatus.OK, payload);
    }

    public static UxReply message(UxQueryContext context, String message) {
        UxBabylonService babylon = context.getUxBabylonService();
        return UxReply.success(new UxMessageReplyPayload(babylon.translate(message, new Serializable[0])));
    }

    public static UxReply validationErrors(UxValidationResult errors) {
        return new UxPayloadReply(UxReplyStatus.ERROR, new UxValidationPayload(errors));
    }

    public static UxReply validationErrors(UxValidationResult errors, UxValidationSynopsis synopsis, UxResultDockName dockName) {
        return new UxPayloadReply(UxReplyStatus.ERROR, new UxValidationPayload(errors.withSynopsis(synopsis).withDockName(dockName)));
    }

    public static UxReply error(UxQueryContext context, CdError<?, ?> error) {
        return UxReply.error(context.asServerRequestContext(), error);
    }

    public static UxReply error(UxServerRequestContext context, CdError<?, ?> error) {
        return UxReply.error(context::getBabylonService, error);
    }

    public static UxReply error(UxOlapBabylonService provider, CdError<?, ?> error) {
        return UxReply.error(provider, error, null);
    }

    public static UxReply error(UxOlapBabylonService provider, CdError<?, ?> error, @Nullable String detailedInformation) {
        OlapBabylonService babylon = provider.service();
        CdErrorCode code = error.getCode();
        String message = error.asMessage((CdBabylonService)babylon);
        return new UxPayloadReply(UxReplyStatus.ERROR, new UxErrorReplyPayload(code.getValue(), message, detailedInformation));
    }

    public static UxReply error(String message) {
        return new UxPayloadReply(UxReplyStatus.ERROR, new UxErrorReplyPayload(null, message, null));
    }

    public void release() {
    }
}

